/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractFormController;

public class SimpleFormController
extends AbstractFormController {
    private String formView;
    private String successView;

    public final void setFormView(String string) {
        this.formView = string;
    }

    public final String getFormView() {
        return this.formView;
    }

    public final void setSuccessView(String string) {
        this.successView = string;
    }

    public final String getSuccessView() {
        return this.successView;
    }

    protected ModelAndView showForm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BindException bindException) throws Exception {
        return this.showForm(httpServletRequest, httpServletResponse, bindException, null);
    }

    protected ModelAndView showForm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BindException bindException, Map map) throws Exception {
        return this.showForm(httpServletRequest, bindException, this.getFormView(), map);
    }

    protected Map referenceData(HttpServletRequest httpServletRequest, Object object, Errors errors) throws Exception {
        return this.referenceData(httpServletRequest);
    }

    protected Map referenceData(HttpServletRequest httpServletRequest) throws Exception {
        return null;
    }

    protected ModelAndView processFormSubmission(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, BindException bindException) throws Exception {
        if (bindException.hasErrors()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Data binding errors: " + bindException.getErrorCount()));
            }
            return this.showForm(httpServletRequest, httpServletResponse, bindException);
        }
        if (this.isFormChangeRequest(httpServletRequest, object)) {
            this.logger.debug((Object)"Detected form change request -> routing request to onFormChange");
            this.onFormChange(httpServletRequest, httpServletResponse, object, bindException);
            return this.showForm(httpServletRequest, httpServletResponse, bindException);
        }
        this.logger.debug((Object)"No errors -> processing submit");
        return this.onSubmit(httpServletRequest, httpServletResponse, object, bindException);
    }

    protected boolean suppressValidation(HttpServletRequest httpServletRequest, Object object) {
        return this.isFormChangeRequest(httpServletRequest, object);
    }

    protected boolean isFormChangeRequest(HttpServletRequest httpServletRequest, Object object) {
        return this.isFormChangeRequest(httpServletRequest);
    }

    protected boolean isFormChangeRequest(HttpServletRequest httpServletRequest) {
        return false;
    }

    protected void onFormChange(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, BindException bindException) throws Exception {
        this.onFormChange(httpServletRequest, httpServletResponse, object);
    }

    protected void onFormChange(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws Exception {
    }

    protected ModelAndView onSubmit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, BindException bindException) throws Exception {
        return this.onSubmit(object, bindException);
    }

    protected ModelAndView onSubmit(Object object, BindException bindException) throws Exception {
        ModelAndView modelAndView = this.onSubmit(object);
        if (modelAndView != null) {
            return modelAndView;
        }
        if (this.getSuccessView() == null) {
            throw new ServletException("successView isn't set");
        }
        return new ModelAndView(this.getSuccessView(), bindException.getModel());
    }

    protected ModelAndView onSubmit(Object object) throws Exception {
        this.doSubmitAction(object);
        return null;
    }

    protected void doSubmitAction(Object object) throws Exception {
    }
}

