/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ServletWrappingController
extends AbstractController
implements BeanNameAware,
InitializingBean,
DisposableBean {
    private Class servletClass;
    private String servletName;
    private Properties initParameters = new Properties();
    private String beanName;
    private Servlet servletInstance;
    static /* synthetic */ Class class$javax$servlet$Servlet;

    public void setServletClass(Class clazz) {
        this.servletClass = clazz;
    }

    public void setServletName(String string) {
        this.servletName = string;
    }

    public void setInitParameters(Properties properties) {
        this.initParameters = properties;
    }

    public void setBeanName(String string) {
        this.beanName = string;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.servletClass == null) {
            throw new IllegalArgumentException("servletClass is required");
        }
        if (!(class$javax$servlet$Servlet == null ? (class$javax$servlet$Servlet = ServletWrappingController.class$("javax.servlet.Servlet")) : class$javax$servlet$Servlet).isAssignableFrom(this.servletClass)) {
            throw new IllegalArgumentException("servletClass [" + this.servletClass.getName() + "] needs to implement interface [javax.servlet.Servlet]");
        }
        if (this.servletName == null) {
            this.servletName = this.beanName;
        }
        this.servletInstance = (Servlet)this.servletClass.newInstance();
        this.servletInstance.init((ServletConfig)new DelegatingServletConfig());
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.servletInstance.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        return null;
    }

    public void destroy() {
        this.servletInstance.destroy();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getServletName() {
            return ServletWrappingController.this.servletName;
        }

        public ServletContext getServletContext() {
            return ServletWrappingController.this.getServletContext();
        }

        public String getInitParameter(String string) {
            return ServletWrappingController.this.initParameters.getProperty(string);
        }

        public Enumeration getInitParameterNames() {
            return ServletWrappingController.this.initParameters.keys();
        }
    }
}

