/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.util.WebUtils;

public class ServletForwardingController
extends AbstractController
implements BeanNameAware {
    private String servletName;
    private String beanName;

    public void setServletName(String string) {
        this.servletName = string;
    }

    public void setBeanName(String string) {
        this.beanName = string;
        if (this.servletName == null) {
            this.servletName = string;
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        RequestDispatcher requestDispatcher = this.getServletContext().getNamedDispatcher(this.servletName);
        if (requestDispatcher == null) {
            throw new ServletException("No servlet with name '" + this.servletName + "' defined in web.xml");
        }
        if (this.useInclude(httpServletRequest, httpServletResponse)) {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Included servlet [" + this.servletName + "] in ServletForwardingController '" + this.beanName + "'"));
            }
        } else {
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Forwarded to servlet [" + this.servletName + "] in ServletForwardingController '" + this.beanName + "'"));
            }
        }
        return null;
    }

    protected boolean useInclude(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return WebUtils.isIncludeRequest((ServletRequest)httpServletRequest) || httpServletResponse.isCommitted();
    }
}

