/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.util.WebUtils;

public class CancellableFormController
extends SimpleFormController {
    private static final String PARAM_CANCEL = "_cancel";
    private String cancelParamKey = "_cancel";
    private String cancelView;

    public final void setCancelParamKey(String string) {
        this.cancelParamKey = string;
    }

    public final String getCancelParamKey() {
        return this.cancelParamKey;
    }

    public final void setCancelView(String string) {
        this.cancelView = string;
    }

    public final String getCancelView() {
        return this.cancelView;
    }

    protected boolean isFormSubmission(HttpServletRequest httpServletRequest) {
        return super.isFormSubmission(httpServletRequest) || this.isCancelRequest(httpServletRequest);
    }

    protected ModelAndView processFormSubmission(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, BindException bindException) throws Exception {
        if (this.isCancelRequest(httpServletRequest)) {
            return this.onCancel(httpServletRequest, httpServletResponse, object);
        }
        return super.processFormSubmission(httpServletRequest, httpServletResponse, object, bindException);
    }

    protected boolean isCancelRequest(HttpServletRequest httpServletRequest) {
        return WebUtils.hasSubmitParameter((ServletRequest)httpServletRequest, (String)this.getCancelParamKey());
    }

    protected ModelAndView onCancel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws Exception {
        return this.onCancel(object);
    }

    protected ModelAndView onCancel(Object object) throws Exception {
        return new ModelAndView(this.getCancelView());
    }
}

