/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.mvc.AbstractController;

public abstract class BaseCommandController
extends AbstractController {
    public static final String DEFAULT_COMMAND_NAME = "command";
    private String commandName = "command";
    private Class commandClass;
    private Validator[] validators;
    private boolean validateOnBinding = true;
    private MessageCodesResolver messageCodesResolver;
    private BindingErrorProcessor bindingErrorProcessor;
    private PropertyEditorRegistrar[] propertyEditorRegistrars;

    public final void setCommandName(String string) {
        this.commandName = string;
    }

    public final String getCommandName() {
        return this.commandName;
    }

    public final void setCommandClass(Class clazz) {
        this.commandClass = clazz;
    }

    public final Class getCommandClass() {
        return this.commandClass;
    }

    public final void setValidator(Validator validator) {
        this.validators = new Validator[]{validator};
    }

    public final Validator getValidator() {
        return this.validators != null && this.validators.length > 0 ? this.validators[0] : null;
    }

    public final void setValidators(Validator[] validatorArray) {
        this.validators = validatorArray;
    }

    public final Validator[] getValidators() {
        return this.validators;
    }

    public final void setValidateOnBinding(boolean bl) {
        this.validateOnBinding = bl;
    }

    public final boolean isValidateOnBinding() {
        return this.validateOnBinding;
    }

    public final void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    public final MessageCodesResolver getMessageCodesResolver() {
        return this.messageCodesResolver;
    }

    public final void setBindingErrorProcessor(BindingErrorProcessor bindingErrorProcessor) {
        this.bindingErrorProcessor = bindingErrorProcessor;
    }

    public final BindingErrorProcessor getBindingErrorProcessor() {
        return this.bindingErrorProcessor;
    }

    public final void setPropertyEditorRegistrar(PropertyEditorRegistrar propertyEditorRegistrar) {
        this.propertyEditorRegistrars = new PropertyEditorRegistrar[]{propertyEditorRegistrar};
    }

    public final void setPropertyEditorRegistrars(PropertyEditorRegistrar[] propertyEditorRegistrarArray) {
        this.propertyEditorRegistrars = propertyEditorRegistrarArray;
    }

    public final PropertyEditorRegistrar[] getPropertyEditorRegistrars() {
        return this.propertyEditorRegistrars;
    }

    protected void initApplicationContext() {
        if (this.validators != null) {
            for (int i = 0; i < this.validators.length; ++i) {
                if (this.commandClass == null || this.validators[i].supports(this.commandClass)) continue;
                throw new IllegalArgumentException("Validator [" + this.validators[i] + "] does not support command class [" + this.commandClass.getName() + "]");
            }
        }
    }

    protected Object getCommand(HttpServletRequest httpServletRequest) throws Exception {
        return this.createCommand();
    }

    protected final Object createCommand() throws Exception {
        if (this.commandClass == null) {
            throw new IllegalStateException("Cannot create command without commandClass being set - either set commandClass or (in a form controller) override formBackingObject");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new command of class [" + this.commandClass.getName() + "]"));
        }
        return BeanUtils.instantiateClass((Class)this.commandClass);
    }

    protected final boolean checkCommand(Object object) {
        return this.commandClass == null || this.commandClass.isInstance(object);
    }

    protected final ServletRequestDataBinder bindAndValidate(HttpServletRequest httpServletRequest, Object object) throws Exception {
        ServletRequestDataBinder servletRequestDataBinder = this.createBinder(httpServletRequest, object);
        BindException bindException = new BindException(servletRequestDataBinder.getBindingResult());
        if (!this.suppressBinding(httpServletRequest)) {
            servletRequestDataBinder.bind((ServletRequest)httpServletRequest);
            this.onBind(httpServletRequest, object, bindException);
            if (this.validators != null && this.isValidateOnBinding() && !this.suppressValidation(httpServletRequest, object, bindException)) {
                for (int i = 0; i < this.validators.length; ++i) {
                    ValidationUtils.invokeValidator((Validator)this.validators[i], (Object)object, (Errors)bindException);
                }
            }
            this.onBindAndValidate(httpServletRequest, object, bindException);
        }
        return servletRequestDataBinder;
    }

    protected boolean suppressBinding(HttpServletRequest httpServletRequest) {
        return false;
    }

    protected ServletRequestDataBinder createBinder(HttpServletRequest httpServletRequest, Object object) throws Exception {
        ServletRequestDataBinder servletRequestDataBinder = new ServletRequestDataBinder(object, this.getCommandName());
        this.prepareBinder(servletRequestDataBinder);
        this.initBinder(httpServletRequest, servletRequestDataBinder);
        return servletRequestDataBinder;
    }

    protected final void prepareBinder(ServletRequestDataBinder servletRequestDataBinder) {
        if (this.useDirectFieldAccess()) {
            servletRequestDataBinder.initDirectFieldAccess();
        }
        if (this.messageCodesResolver != null) {
            servletRequestDataBinder.setMessageCodesResolver(this.messageCodesResolver);
        }
        if (this.bindingErrorProcessor != null) {
            servletRequestDataBinder.setBindingErrorProcessor(this.bindingErrorProcessor);
        }
        if (this.propertyEditorRegistrars != null) {
            for (int i = 0; i < this.propertyEditorRegistrars.length; ++i) {
                this.propertyEditorRegistrars[i].registerCustomEditors((PropertyEditorRegistry)servletRequestDataBinder);
            }
        }
    }

    protected boolean useDirectFieldAccess() {
        return false;
    }

    protected void initBinder(HttpServletRequest httpServletRequest, ServletRequestDataBinder servletRequestDataBinder) throws Exception {
    }

    protected void onBind(HttpServletRequest httpServletRequest, Object object, BindException bindException) throws Exception {
        this.onBind(httpServletRequest, object);
    }

    protected void onBind(HttpServletRequest httpServletRequest, Object object) throws Exception {
    }

    protected boolean suppressValidation(HttpServletRequest httpServletRequest, Object object, BindException bindException) {
        return this.suppressValidation(httpServletRequest, object);
    }

    protected boolean suppressValidation(HttpServletRequest httpServletRequest, Object object) {
        return this.suppressValidation(httpServletRequest);
    }

    protected boolean suppressValidation(HttpServletRequest httpServletRequest) {
        return false;
    }

    protected void onBindAndValidate(HttpServletRequest httpServletRequest, Object object, BindException bindException) throws Exception {
    }
}

