/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractFormController;
import org.springframework.web.util.WebUtils;

public abstract class AbstractWizardFormController
extends AbstractFormController {
    public static final String PARAM_FINISH = "_finish";
    public static final String PARAM_CANCEL = "_cancel";
    public static final String PARAM_TARGET = "_target";
    public static final String PARAM_PAGE = "_page";
    private String[] pages;
    private String pageAttribute;
    private boolean allowDirtyBack = true;
    private boolean allowDirtyForward = false;

    public AbstractWizardFormController() {
        this.setSessionForm(true);
        this.setValidateOnBinding(false);
    }

    public final void setPages(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No wizard pages defined");
        }
        this.pages = stringArray;
    }

    public final String[] getPages() {
        return this.pages;
    }

    protected final int getPageCount() {
        return this.pages.length;
    }

    public final void setPageAttribute(String string) {
        this.pageAttribute = string;
    }

    public final String getPageAttribute() {
        return this.pageAttribute;
    }

    public final void setAllowDirtyBack(boolean bl) {
        this.allowDirtyBack = bl;
    }

    public final boolean isAllowDirtyBack() {
        return this.allowDirtyBack;
    }

    public final void setAllowDirtyForward(boolean bl) {
        this.allowDirtyForward = bl;
    }

    public final boolean isAllowDirtyForward() {
        return this.allowDirtyForward;
    }

    protected final void onBindAndValidate(HttpServletRequest httpServletRequest, Object object, BindException bindException) throws Exception {
        this.onBindAndValidate(httpServletRequest, object, bindException, this.getCurrentPage(httpServletRequest));
    }

    protected void onBindAndValidate(HttpServletRequest httpServletRequest, Object object, BindException bindException, int n) throws Exception {
    }

    protected boolean isFormSubmission(HttpServletRequest httpServletRequest) {
        return super.isFormSubmission(httpServletRequest) || this.isFinishRequest(httpServletRequest) || this.isCancelRequest(httpServletRequest);
    }

    protected final Map referenceData(HttpServletRequest httpServletRequest, Object object, Errors errors) throws Exception {
        return this.referenceData(httpServletRequest, object, errors, this.getCurrentPage(httpServletRequest));
    }

    protected Map referenceData(HttpServletRequest httpServletRequest, Object object, Errors errors, int n) throws Exception {
        return this.referenceData(httpServletRequest, n);
    }

    protected Map referenceData(HttpServletRequest httpServletRequest, int n) throws Exception {
        return null;
    }

    protected final ModelAndView showForm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BindException bindException) throws Exception {
        return this.showPage(httpServletRequest, bindException, this.getInitialPage(httpServletRequest, bindException.getTarget()));
    }

    protected final ModelAndView showPage(HttpServletRequest httpServletRequest, BindException bindException, int n) throws Exception {
        if (n >= 0 && n < this.getPageCount(httpServletRequest, bindException.getTarget())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Showing wizard page " + n + " for form bean '" + this.getCommandName() + "'"));
            }
            Integer n2 = new Integer(n);
            String string = this.getPageSessionAttributeName(httpServletRequest);
            if (this.isSessionForm()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting page session attribute [" + string + "] to: " + n2));
                }
                httpServletRequest.getSession().setAttribute(string, (Object)n2);
            }
            httpServletRequest.setAttribute(string, (Object)n2);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            if (this.pageAttribute != null) {
                hashMap.put(this.pageAttribute, new Integer(n));
            }
            String string2 = this.getViewName(httpServletRequest, bindException.getTarget(), n);
            return this.showForm(httpServletRequest, bindException, string2, hashMap);
        }
        throw new ServletException("Invalid wizard page number: " + n);
    }

    protected int getPageCount(HttpServletRequest httpServletRequest, Object object) {
        return this.getPageCount();
    }

    protected String getViewName(HttpServletRequest httpServletRequest, Object object, int n) {
        return this.getPages()[n];
    }

    protected int getInitialPage(HttpServletRequest httpServletRequest, Object object) {
        return this.getInitialPage(httpServletRequest);
    }

    protected int getInitialPage(HttpServletRequest httpServletRequest) {
        return 0;
    }

    protected String getPageSessionAttributeName(HttpServletRequest httpServletRequest) {
        return this.getPageSessionAttributeName();
    }

    protected String getPageSessionAttributeName() {
        return this.getClass().getName() + ".PAGE." + this.getCommandName();
    }

    protected ModelAndView handleInvalidSubmit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        return this.showNewForm(httpServletRequest, httpServletResponse);
    }

    protected final ModelAndView processFormSubmission(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, BindException bindException) throws Exception {
        int n = this.getCurrentPage(httpServletRequest);
        String string = this.getPageSessionAttributeName(httpServletRequest);
        if (this.isSessionForm()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing page session attribute [" + string + "]"));
            }
            httpServletRequest.getSession().removeAttribute(string);
        }
        httpServletRequest.setAttribute(string, (Object)new Integer(n));
        if (this.isCancelRequest(httpServletRequest)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cancelling wizard for form bean '" + this.getCommandName() + "'"));
            }
            return this.processCancel(httpServletRequest, httpServletResponse, object, bindException);
        }
        if (this.isFinishRequest(httpServletRequest)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Finishing wizard for form bean '" + this.getCommandName() + "'"));
            }
            return this.validatePagesAndFinish(httpServletRequest, httpServletResponse, object, bindException, n);
        }
        if (!this.suppressValidation(httpServletRequest, object, bindException)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Validating wizard page " + n + " for form bean '" + this.getCommandName() + "'"));
            }
            this.validatePage(object, (Errors)bindException, n, false);
        }
        this.postProcessPage(httpServletRequest, object, (Errors)bindException, n);
        int n2 = this.getTargetPage(httpServletRequest, object, (Errors)bindException, n);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Target page " + n2 + " requested"));
        }
        if (n2 != n && (!bindException.hasErrors() || this.allowDirtyBack && n2 < n || this.allowDirtyForward && n2 > n)) {
            return this.showPage(httpServletRequest, bindException, n2);
        }
        return this.showPage(httpServletRequest, bindException, n);
    }

    protected int getCurrentPage(HttpServletRequest httpServletRequest) {
        String string = this.getPageSessionAttributeName(httpServletRequest);
        Integer n = (Integer)httpServletRequest.getAttribute(string);
        if (n != null) {
            return n;
        }
        String string2 = httpServletRequest.getParameter(PARAM_PAGE);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        if (this.isSessionForm() && (n = (Integer)httpServletRequest.getSession().getAttribute(string)) != null) {
            return n;
        }
        throw new IllegalStateException("Page attribute [" + string + "] neither found in session nor in request");
    }

    protected boolean isFinishRequest(HttpServletRequest httpServletRequest) {
        return WebUtils.hasSubmitParameter((ServletRequest)httpServletRequest, (String)PARAM_FINISH);
    }

    protected boolean isCancelRequest(HttpServletRequest httpServletRequest) {
        return WebUtils.hasSubmitParameter((ServletRequest)httpServletRequest, (String)PARAM_CANCEL);
    }

    protected int getTargetPage(HttpServletRequest httpServletRequest, Object object, Errors errors, int n) {
        return this.getTargetPage(httpServletRequest, n);
    }

    protected int getTargetPage(HttpServletRequest httpServletRequest, int n) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(PARAM_TARGET)) continue;
            for (int i = 0; i < WebUtils.SUBMIT_IMAGE_SUFFIXES.length; ++i) {
                String string2 = WebUtils.SUBMIT_IMAGE_SUFFIXES[i];
                if (!string.endsWith(string2)) continue;
                string = string.substring(0, string.length() - string2.length());
            }
            return Integer.parseInt(string.substring(PARAM_TARGET.length()));
        }
        return n;
    }

    private ModelAndView validatePagesAndFinish(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, BindException bindException, int n) throws Exception {
        if (bindException.hasErrors()) {
            return this.showPage(httpServletRequest, bindException, n);
        }
        if (!this.suppressValidation(httpServletRequest, object, bindException)) {
            for (int i = 0; i < this.getPageCount(httpServletRequest, object); ++i) {
                this.validatePage(object, (Errors)bindException, i, true);
                if (!bindException.hasErrors()) continue;
                return this.showPage(httpServletRequest, bindException, i);
            }
        }
        return this.processFinish(httpServletRequest, httpServletResponse, object, bindException);
    }

    protected void validatePage(Object object, Errors errors, int n, boolean bl) {
        this.validatePage(object, errors, n);
    }

    protected void validatePage(Object object, Errors errors, int n) {
    }

    protected void postProcessPage(HttpServletRequest httpServletRequest, Object object, Errors errors, int n) throws Exception {
    }

    protected abstract ModelAndView processFinish(HttpServletRequest var1, HttpServletResponse var2, Object var3, BindException var4) throws Exception;

    protected ModelAndView processCancel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, BindException bindException) throws Exception {
        throw new ServletException("Wizard form controller class [" + this.getClass().getName() + "] does not support a cancel operation");
    }
}

