/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.BaseCommandController;

public abstract class AbstractFormController
extends BaseCommandController {
    private boolean bindOnNewForm = false;
    private boolean sessionForm = false;

    public AbstractFormController() {
        this.setCacheSeconds(0);
    }

    public final void setBindOnNewForm(boolean bl) {
        this.bindOnNewForm = bl;
    }

    public final boolean isBindOnNewForm() {
        return this.bindOnNewForm;
    }

    public final void setSessionForm(boolean bl) {
        this.sessionForm = bl;
    }

    public final boolean isSessionForm() {
        return this.sessionForm;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this.isFormSubmission(httpServletRequest)) {
            try {
                Object object = this.getCommand(httpServletRequest);
                ServletRequestDataBinder servletRequestDataBinder = this.bindAndValidate(httpServletRequest, object);
                BindException bindException = new BindException(servletRequestDataBinder.getBindingResult());
                return this.processFormSubmission(httpServletRequest, httpServletResponse, object, bindException);
            }
            catch (HttpSessionRequiredException httpSessionRequiredException) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invalid submit detected: " + httpSessionRequiredException.getMessage()));
                }
                return this.handleInvalidSubmit(httpServletRequest, httpServletResponse);
            }
        }
        return this.showNewForm(httpServletRequest, httpServletResponse);
    }

    protected boolean isFormSubmission(HttpServletRequest httpServletRequest) {
        return "POST".equals(httpServletRequest.getMethod());
    }

    protected String getFormSessionAttributeName(HttpServletRequest httpServletRequest) {
        return this.getFormSessionAttributeName();
    }

    protected String getFormSessionAttributeName() {
        return this.getClass().getName() + ".FORM." + this.getCommandName();
    }

    protected final ModelAndView showNewForm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.logger.debug((Object)"Displaying new form");
        return this.showForm(httpServletRequest, httpServletResponse, this.getErrorsForNewForm(httpServletRequest));
    }

    protected final BindException getErrorsForNewForm(HttpServletRequest httpServletRequest) throws Exception {
        Object object = this.formBackingObject(httpServletRequest);
        if (object == null) {
            throw new ServletException("Form object returned by formBackingObject() must not be null");
        }
        if (!this.checkCommand(object)) {
            throw new ServletException("Form object returned by formBackingObject() must match commandClass");
        }
        ServletRequestDataBinder servletRequestDataBinder = this.createBinder(httpServletRequest, object);
        BindException bindException = new BindException(servletRequestDataBinder.getBindingResult());
        if (this.isBindOnNewForm()) {
            this.logger.debug((Object)"Binding to new form");
            servletRequestDataBinder.bind((ServletRequest)httpServletRequest);
            this.onBindOnNewForm(httpServletRequest, object, bindException);
        }
        return bindException;
    }

    protected void onBindOnNewForm(HttpServletRequest httpServletRequest, Object object, BindException bindException) throws Exception {
        this.onBindOnNewForm(httpServletRequest, object);
    }

    protected void onBindOnNewForm(HttpServletRequest httpServletRequest, Object object) throws Exception {
    }

    protected final Object getCommand(HttpServletRequest httpServletRequest) throws Exception {
        if (!this.isSessionForm()) {
            return this.formBackingObject(httpServletRequest);
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            throw new HttpSessionRequiredException("Must have session when trying to bind (in session-form mode)");
        }
        String string = this.getFormSessionAttributeName(httpServletRequest);
        Object object = httpSession.getAttribute(string);
        if (object == null) {
            throw new HttpSessionRequiredException("Form object not found in session (in session-form mode)");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing form session attribute [" + string + "]"));
        }
        httpSession.removeAttribute(string);
        return this.currentFormObject(httpServletRequest, object);
    }

    protected Object formBackingObject(HttpServletRequest httpServletRequest) throws Exception {
        return this.createCommand();
    }

    protected Object currentFormObject(HttpServletRequest httpServletRequest, Object object) throws Exception {
        return object;
    }

    protected abstract ModelAndView showForm(HttpServletRequest var1, HttpServletResponse var2, BindException var3) throws Exception;

    protected final ModelAndView showForm(HttpServletRequest httpServletRequest, BindException bindException, String string) throws Exception {
        return this.showForm(httpServletRequest, bindException, string, null);
    }

    protected final ModelAndView showForm(HttpServletRequest httpServletRequest, BindException bindException, String string, Map map) throws Exception {
        Object object;
        if (this.isSessionForm()) {
            object = this.getFormSessionAttributeName(httpServletRequest);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting form session attribute [" + (String)object + "] to: " + bindException.getTarget()));
            }
            httpServletRequest.getSession().setAttribute((String)object, bindException.getTarget());
        }
        object = bindException.getModel();
        Map map2 = this.referenceData(httpServletRequest, bindException.getTarget(), (Errors)bindException);
        if (map2 != null) {
            object.putAll(map2);
        }
        if (map != null) {
            object.putAll(map);
        }
        return new ModelAndView(string, (Map)object);
    }

    protected Map referenceData(HttpServletRequest httpServletRequest, Object object, Errors errors) throws Exception {
        return null;
    }

    protected abstract ModelAndView processFormSubmission(HttpServletRequest var1, HttpServletResponse var2, Object var3, BindException var4) throws Exception;

    protected ModelAndView handleInvalidSubmit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object = this.formBackingObject(httpServletRequest);
        ServletRequestDataBinder servletRequestDataBinder = this.bindAndValidate(httpServletRequest, object);
        BindException bindException = new BindException(servletRequestDataBinder.getBindingResult());
        return this.processFormSubmission(httpServletRequest, httpServletResponse, object, bindException);
    }
}

