/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.i18n;

import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public class CookieLocaleResolver
extends CookieGenerator
implements LocaleResolver {
    public static final String LOCALE_REQUEST_ATTRIBUTE_NAME = (class$org$springframework$web$servlet$i18n$CookieLocaleResolver == null ? (class$org$springframework$web$servlet$i18n$CookieLocaleResolver = CookieLocaleResolver.class$("org.springframework.web.servlet.i18n.CookieLocaleResolver")) : class$org$springframework$web$servlet$i18n$CookieLocaleResolver).getName() + ".LOCALE";
    public static final String DEFAULT_COOKIE_NAME = (class$org$springframework$web$servlet$i18n$CookieLocaleResolver == null ? (class$org$springframework$web$servlet$i18n$CookieLocaleResolver = CookieLocaleResolver.class$("org.springframework.web.servlet.i18n.CookieLocaleResolver")) : class$org$springframework$web$servlet$i18n$CookieLocaleResolver).getName() + ".LOCALE";
    private Locale defaultLocale;
    static /* synthetic */ Class class$org$springframework$web$servlet$i18n$CookieLocaleResolver;

    public CookieLocaleResolver() {
        this.setCookieName(DEFAULT_COOKIE_NAME);
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    protected Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public Locale resolveLocale(HttpServletRequest httpServletRequest) {
        Locale locale = (Locale)httpServletRequest.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
        if (locale != null) {
            return locale;
        }
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)this.getCookieName());
        if (cookie != null) {
            locale = StringUtils.parseLocaleString((String)cookie.getValue());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Parsed cookie value [" + cookie.getValue() + "] into locale '" + locale + "'"));
            }
            if (locale != null) {
                httpServletRequest.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)locale);
                return locale;
            }
        }
        return this.determineDefaultLocale(httpServletRequest);
    }

    protected Locale determineDefaultLocale(HttpServletRequest httpServletRequest) {
        Locale locale = this.getDefaultLocale();
        if (locale == null) {
            locale = httpServletRequest.getLocale();
        }
        return locale;
    }

    public void setLocale(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) {
        if (locale != null) {
            httpServletRequest.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)locale);
            this.addCookie(httpServletResponse, locale.toString());
        } else {
            httpServletRequest.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)httpServletRequest.getLocale());
            this.removeCookie(httpServletResponse);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

