/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler.metadata;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Constants;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import org.springframework.web.servlet.handler.metadata.PathMap;

public abstract class AbstractPathMapHandlerMapping
extends AbstractUrlHandlerMapping {
    private static final Constants constants = new Constants(class$org$springframework$beans$factory$config$AutowireCapableBeanFactory == null ? (class$org$springframework$beans$factory$config$AutowireCapableBeanFactory = AbstractPathMapHandlerMapping.class$("org.springframework.beans.factory.config.AutowireCapableBeanFactory")) : class$org$springframework$beans$factory$config$AutowireCapableBeanFactory);
    private int autowireMode = 4;
    private boolean dependencyCheck = true;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$AutowireCapableBeanFactory;

    public void setAutowireModeName(String string) throws IllegalArgumentException {
        this.setAutowireMode(constants.asNumber(string).intValue());
    }

    public void setAutowireMode(int n) {
        this.autowireMode = n;
    }

    public void setDependencyCheck(boolean bl) {
        this.dependencyCheck = bl;
    }

    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        if (!(this.getApplicationContext() instanceof ConfigurableApplicationContext)) {
            throw new IllegalStateException("[" + this.getClass().getName() + "] needs to run in a ConfigurableApplicationContext");
        }
        ConfigurableListableBeanFactory configurableListableBeanFactory = ((ConfigurableApplicationContext)this.getApplicationContext()).getBeanFactory();
        this.detectAndCreateHandlers(configurableListableBeanFactory);
    }

    protected void detectAndCreateHandlers(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        try {
            Class[] classArray = this.getClassesWithPathMapAttributes();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found " + classArray.length + " attribute-targeted handlers"));
            }
            for (int i = 0; i < classArray.length; ++i) {
                Class clazz = classArray[i];
                Object object = configurableListableBeanFactory.createBean(clazz, this.autowireMode, this.dependencyCheck);
                configurableListableBeanFactory.registerSingleton(clazz.getName(), object);
                PathMap[] pathMapArray = this.getPathMapAttributes(clazz);
                this.registerHandler(pathMapArray, object);
            }
        }
        catch (BeansException beansException) {
            throw beansException;
        }
        catch (Exception exception) {
            throw new BeanInitializationException("Could not retrieve PathMap attributes", (Throwable)exception);
        }
    }

    protected void registerHandler(PathMap[] pathMapArray, Object object) throws BeansException, IllegalStateException {
        for (int i = 0; i < pathMapArray.length; ++i) {
            PathMap pathMap = pathMapArray[i];
            String string = pathMap.getUrl();
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            this.registerHandler(string, object);
        }
    }

    protected abstract Class[] getClassesWithPathMapAttributes() throws Exception;

    protected abstract PathMap[] getPathMapAttributes(Class var1) throws Exception;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

