/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.DispatcherServletWebRequest;

public class WebRequestHandlerInterceptorAdapter
implements HandlerInterceptor {
    private final WebRequestInterceptor requestInterceptor;

    public WebRequestHandlerInterceptorAdapter(WebRequestInterceptor webRequestInterceptor) {
        Assert.notNull((Object)webRequestInterceptor, (String)"WebRequestInterceptor must not be null");
        this.requestInterceptor = webRequestInterceptor;
    }

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws Exception {
        this.requestInterceptor.preHandle((WebRequest)new DispatcherServletWebRequest(httpServletRequest));
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, ModelAndView modelAndView) throws Exception {
        this.requestInterceptor.postHandle((WebRequest)new DispatcherServletWebRequest(httpServletRequest), modelAndView != null ? modelAndView.getModelMap() : null);
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, Exception exception) throws Exception {
        this.requestInterceptor.afterCompletion((WebRequest)new DispatcherServletWebRequest(httpServletRequest), exception);
    }
}

