/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.context.ServletContextAware;

public class SimpleServletPostProcessor
implements DestructionAwareBeanPostProcessor,
ServletContextAware,
ServletConfigAware {
    private boolean useSharedServletConfig = true;
    private ServletContext servletContext;
    private ServletConfig servletConfig;

    public void setUseSharedServletConfig(boolean bl) {
        this.useSharedServletConfig = bl;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public Object postProcessBeforeInitialization(Object object, String string) throws BeansException {
        return object;
    }

    public Object postProcessAfterInitialization(Object object, String string) throws BeansException {
        if (object instanceof Servlet) {
            ServletConfig servletConfig = this.servletConfig;
            if (servletConfig == null || !this.useSharedServletConfig) {
                servletConfig = new DelegatingServletConfig(string, this.servletContext);
            }
            try {
                ((Servlet)object).init(servletConfig);
            }
            catch (ServletException servletException) {
                throw new BeanInitializationException("Servlet.init threw exception", (Throwable)servletException);
            }
        }
        return object;
    }

    public void postProcessBeforeDestruction(Object object, String string) throws BeansException {
        if (object instanceof Servlet) {
            ((Servlet)object).destroy();
        }
    }

    private static class DelegatingServletConfig
    implements ServletConfig {
        private final String servletName;
        private final ServletContext servletContext;

        public DelegatingServletConfig(String string, ServletContext servletContext) {
            this.servletName = string;
            this.servletContext = servletContext;
        }

        public String getServletName() {
            return this.servletName;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getInitParameter(String string) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(Collections.EMPTY_SET);
        }
    }
}

