/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.WebUtils;

public class SimpleMappingExceptionResolver
implements HandlerExceptionResolver,
Ordered {
    public static final String DEFAULT_EXCEPTION_ATTRIBUTE = "exception";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private Set mappedHandlers;
    private Class[] mappedHandlerClasses;
    private Log warnLogger;
    private Properties exceptionMappings;
    private String defaultErrorView;
    private Integer defaultStatusCode;
    private String exceptionAttribute = "exception";
    static /* synthetic */ Class class$java$lang$Throwable;

    public void setOrder(int n) {
        this.order = n;
    }

    public int getOrder() {
        return this.order;
    }

    public void setMappedHandlers(Set set) {
        this.mappedHandlers = set;
    }

    public void setMappedHandlerClasses(Class[] classArray) {
        this.mappedHandlerClasses = classArray;
    }

    public void setWarnLogCategory(String string) {
        this.warnLogger = LogFactory.getLog((String)string);
    }

    public void setExceptionMappings(Properties properties) {
        this.exceptionMappings = properties;
    }

    public void setDefaultErrorView(String string) {
        this.defaultErrorView = string;
    }

    public void setDefaultStatusCode(int n) {
        this.defaultStatusCode = new Integer(n);
    }

    public void setExceptionAttribute(String string) {
        this.exceptionAttribute = string;
    }

    public ModelAndView resolveException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, Exception exception) {
        if (this.shouldApplyTo(httpServletRequest, object)) {
            return this.doResolveException(httpServletRequest, httpServletResponse, object, exception);
        }
        return null;
    }

    protected boolean shouldApplyTo(HttpServletRequest httpServletRequest, Object object) {
        if (object != null) {
            if (this.mappedHandlers != null && this.mappedHandlers.contains(object)) {
                return true;
            }
            if (this.mappedHandlerClasses != null) {
                for (int i = 0; i < this.mappedHandlerClasses.length; ++i) {
                    if (!this.mappedHandlerClasses[i].isInstance(object)) continue;
                    return true;
                }
            }
        }
        return this.mappedHandlers == null && this.mappedHandlerClasses == null;
    }

    protected ModelAndView doResolveException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, Exception exception) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving exception from handler [" + object + "]: " + exception));
        }
        this.logException(exception, httpServletRequest);
        String string = this.determineViewName(exception, httpServletRequest);
        if (string != null) {
            Integer n = this.determineStatusCode(httpServletRequest, string);
            if (n != null) {
                this.applyStatusCodeIfPossible(httpServletRequest, httpServletResponse, n);
            }
            return this.getModelAndView(string, exception, httpServletRequest);
        }
        return null;
    }

    protected void logException(Exception exception, HttpServletRequest httpServletRequest) {
        if (this.warnLogger != null && this.warnLogger.isWarnEnabled()) {
            this.warnLogger.warn((Object)this.buildLogMessage(exception, httpServletRequest), (Throwable)exception);
        }
    }

    protected String buildLogMessage(Exception exception, HttpServletRequest httpServletRequest) {
        return "Handler execution resulted in exception";
    }

    protected String determineViewName(Exception exception, HttpServletRequest httpServletRequest) {
        String string = null;
        if (this.exceptionMappings != null) {
            string = this.findMatchingViewName(this.exceptionMappings, exception);
        }
        if (string == null && this.defaultErrorView != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resolving to default view '" + this.defaultErrorView + "' for exception of type [" + exception.getClass().getName() + "]"));
            }
            string = this.defaultErrorView;
        }
        return string;
    }

    protected String findMatchingViewName(Properties properties, Exception exception) {
        String string = null;
        String string2 = null;
        int n = Integer.MAX_VALUE;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            int n2 = this.getDepth(string3, exception);
            if (n2 < 0 || n2 >= n) continue;
            n = n2;
            string2 = string3;
            string = properties.getProperty(string3);
        }
        if (string != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving to view '" + string + "' for exception of type [" + exception.getClass().getName() + "], based on exception mapping [" + string2 + "]"));
        }
        return string;
    }

    protected int getDepth(String string, Exception exception) {
        return this.getDepth(string, exception.getClass(), 0);
    }

    private int getDepth(String string, Class clazz, int n) {
        if (clazz.getName().indexOf(string) != -1) {
            return n;
        }
        if (clazz.equals(class$java$lang$Throwable == null ? (class$java$lang$Throwable = SimpleMappingExceptionResolver.class$("java.lang.Throwable")) : class$java$lang$Throwable)) {
            return -1;
        }
        return this.getDepth(string, clazz.getSuperclass(), n + 1);
    }

    protected Integer determineStatusCode(HttpServletRequest httpServletRequest, String string) {
        return this.defaultStatusCode;
    }

    protected void applyStatusCodeIfPossible(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n) {
        if (!WebUtils.isIncludeRequest((ServletRequest)httpServletRequest)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying HTTP status code " + n));
            }
            httpServletResponse.setStatus(n);
        }
    }

    protected ModelAndView getModelAndView(String string, Exception exception, HttpServletRequest httpServletRequest) {
        return this.getModelAndView(string, exception);
    }

    protected ModelAndView getModelAndView(String string, Exception exception) {
        ModelAndView modelAndView = new ModelAndView(string);
        if (this.exceptionAttribute != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Exposing Exception as model attribute '" + this.exceptionAttribute + "'"));
            }
            modelAndView.addObject(this.exceptionAttribute, exception);
        }
        return modelAndView;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

