/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class BeanNameUrlHandlerMapping
extends AbstractUrlHandlerMapping {
    private boolean detectHandlersInAncestorContexts = false;
    static /* synthetic */ Class class$java$lang$Object;

    public void setDetectHandlersInAncestorContexts(boolean bl) {
        this.detectHandlersInAncestorContexts = bl;
    }

    public void initApplicationContext() throws ApplicationContextException {
        super.initApplicationContext();
        this.detectHandlers();
    }

    protected void detectHandlers() throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for URL mappings in application context: " + this.getApplicationContext()));
        }
        String[] stringArray = this.detectHandlersInAncestorContexts ? BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), (Class)(class$java$lang$Object == null ? (class$java$lang$Object = BeanNameUrlHandlerMapping.class$("java.lang.Object")) : class$java$lang$Object)) : this.getApplicationContext().getBeanNamesForType(class$java$lang$Object == null ? (class$java$lang$Object = BeanNameUrlHandlerMapping.class$("java.lang.Object")) : class$java$lang$Object);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = this.determineUrlsForHandler(string);
            if (stringArray2.length > 0) {
                this.registerHandler(stringArray2, string);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Rejected bean name '" + stringArray[i] + "': no URL paths identified"));
        }
    }

    protected String[] determineUrlsForHandler(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.startsWith("/")) {
            arrayList.add(string);
        }
        String[] stringArray = this.getApplicationContext().getAliases(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("/")) continue;
            arrayList.add(stringArray[i]);
        }
        return StringUtils.toStringArray(arrayList);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

