/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractUrlHandlerMapping
extends AbstractHandlerMapping {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private Object rootHandler;
    private boolean lazyInitHandlers = false;
    private final Map handlerMap = new HashMap();

    public void setAlwaysUseFullPath(boolean bl) {
        this.urlPathHelper.setAlwaysUseFullPath(bl);
    }

    public void setUrlDecode(boolean bl) {
        this.urlPathHelper.setUrlDecode(bl);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public void setRootHandler(Object object) {
        this.rootHandler = object;
    }

    public Object getRootHandler() {
        return this.rootHandler;
    }

    public void setLazyInitHandlers(boolean bl) {
        this.lazyInitHandlers = bl;
    }

    protected Object getHandlerInternal(HttpServletRequest httpServletRequest) throws Exception {
        Object object;
        String string = this.urlPathHelper.getLookupPathForRequest(httpServletRequest);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up handler for [" + string + "]"));
        }
        if ((object = this.lookupHandler(string, httpServletRequest)) == null) {
            if ("/".equals(string)) {
                object = this.getRootHandler();
            }
            if (object == null) {
                object = this.getDefaultHandler();
            }
            if (object != null) {
                this.exposePathWithinMapping(string, httpServletRequest);
            }
        }
        return object;
    }

    protected Object lookupHandler(String string, HttpServletRequest httpServletRequest) {
        Object v = this.handlerMap.get(string);
        if (v != null) {
            this.exposePathWithinMapping(string, httpServletRequest);
            return v;
        }
        String string2 = null;
        Iterator iterator = this.handlerMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!this.pathMatcher.match(string3, string) || string2 != null && string2.length() > string3.length()) continue;
            string2 = string3;
        }
        if (string2 != null) {
            v = this.handlerMap.get(string2);
            this.exposePathWithinMapping(this.pathMatcher.extractPathWithinPattern(string2, string), httpServletRequest);
        }
        return v;
    }

    protected void exposePathWithinMapping(String string, HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, (Object)string);
    }

    protected void registerHandler(String[] stringArray, String string) throws BeansException, IllegalStateException {
        Assert.notNull((Object)stringArray, (String)"URL path array must not be null");
        for (int i = 0; i < stringArray.length; ++i) {
            this.registerHandler(stringArray[i], (Object)string);
        }
    }

    protected void registerHandler(String string, Object object) throws BeansException, IllegalStateException {
        Assert.notNull((Object)string, (String)"URL path must not be null");
        Assert.notNull((Object)object, (String)"Handler object must not be null");
        Object v = this.handlerMap.get(string);
        if (v != null) {
            throw new IllegalStateException("Cannot map handler [" + object + "] to URL path [" + string + "]: There is already handler [" + v + "] mapped.");
        }
        if (!this.lazyInitHandlers && object instanceof String) {
            String string2 = (String)object;
            if (this.getApplicationContext().isSingleton(string2)) {
                object = this.getApplicationContext().getBean(string2);
            }
        }
        if (string.equals("/")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Root mapping to handler [" + object + "]"));
            }
            this.setRootHandler(object);
        } else if (string.equals("/*")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Default mapping to handler [" + object + "]"));
            }
            this.setDefaultHandler(object);
        } else {
            this.handlerMap.put(string, object);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Mapped URL path [" + string + "] onto handler [" + object + "]"));
            }
        }
    }

    public final Map getHandlerMap() {
        return Collections.unmodifiableMap(this.handlerMap);
    }
}

