/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.core.Ordered;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;

public abstract class AbstractHandlerMapping
extends WebApplicationObjectSupport
implements HandlerMapping,
Ordered {
    private int order = Integer.MAX_VALUE;
    private Object defaultHandler;
    private final List interceptors = new ArrayList();
    private HandlerInterceptor[] adaptedInterceptors;

    public final void setOrder(int n) {
        this.order = n;
    }

    public final int getOrder() {
        return this.order;
    }

    public void setDefaultHandler(Object object) {
        this.defaultHandler = object;
    }

    public Object getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setInterceptors(Object[] objectArray) {
        this.interceptors.addAll(Arrays.asList(objectArray));
    }

    protected void initApplicationContext() throws BeansException {
        this.extendInterceptors(this.interceptors);
        this.initInterceptors();
    }

    protected void extendInterceptors(List list) {
    }

    protected void initInterceptors() {
        if (!this.interceptors.isEmpty()) {
            this.adaptedInterceptors = new HandlerInterceptor[this.interceptors.size()];
            for (int i = 0; i < this.interceptors.size(); ++i) {
                Object e = this.interceptors.get(i);
                if (e == null) {
                    throw new IllegalArgumentException("Entry number " + i + " in interceptors array is null");
                }
                this.adaptedInterceptors[i] = this.adaptInterceptor(e);
            }
        }
    }

    protected HandlerInterceptor adaptInterceptor(Object object) {
        if (object instanceof HandlerInterceptor) {
            return (HandlerInterceptor)object;
        }
        if (object instanceof WebRequestInterceptor) {
            return new WebRequestHandlerInterceptorAdapter((WebRequestInterceptor)object);
        }
        throw new IllegalArgumentException("Interceptor type not supported: " + object.getClass().getName());
    }

    protected final HandlerInterceptor[] getAdaptedInterceptors() {
        return this.adaptedInterceptors;
    }

    public final HandlerExecutionChain getHandler(HttpServletRequest httpServletRequest) throws Exception {
        Object object = this.getHandlerInternal(httpServletRequest);
        if (object == null) {
            object = this.getDefaultHandler();
        }
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            object = this.getApplicationContext().getBean(string);
        }
        return this.getHandlerExecutionChain(object, httpServletRequest);
    }

    protected abstract Object getHandlerInternal(HttpServletRequest var1) throws Exception;

    protected HandlerExecutionChain getHandlerExecutionChain(Object object, HttpServletRequest httpServletRequest) {
        return new HandlerExecutionChain(object, this.getAdaptedInterceptors());
    }
}

