/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.servlet.HttpServletBean;

public class ResourceServlet
extends HttpServletBean {
    public static final String RESOURCE_URL_DELIMITERS = ",; \t\n";
    public static final String RESOURCE_PARAM_NAME = "resource";
    private String defaultUrl;
    private String allowedResources;
    private String contentType;
    private boolean applyLastModified = false;
    private PathMatcher pathMatcher;
    private long startupTime;

    public void setDefaultUrl(String string) {
        this.defaultUrl = string;
    }

    public void setAllowedResources(String string) {
        this.allowedResources = string;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setApplyLastModified(boolean bl) {
        this.applyLastModified = bl;
    }

    protected void initServletBean() {
        this.pathMatcher = this.getPathMatcher();
        this.startupTime = System.currentTimeMillis();
    }

    protected PathMatcher getPathMatcher() {
        return new AntPathMatcher();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.determineResourceUrl(httpServletRequest);
        if (string != null) {
            try {
                this.doInclude(httpServletRequest, httpServletResponse, string);
                return;
            }
            catch (ServletException servletException) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Failed to include content of resource [" + string + "]"), (Throwable)servletException);
                }
                if (this.includeDefaultUrl(httpServletRequest, httpServletResponse)) return;
                throw servletException;
            }
            catch (IOException iOException) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Failed to include content of resource [" + string + "]"), (Throwable)iOException);
                }
                if (this.includeDefaultUrl(httpServletRequest, httpServletResponse)) return;
                throw iOException;
            }
        } else {
            if (this.includeDefaultUrl(httpServletRequest, httpServletResponse)) return;
            throw new ServletException("No target resource URL found for request");
        }
    }

    protected String determineResourceUrl(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getParameter(RESOURCE_PARAM_NAME);
    }

    private boolean includeDefaultUrl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.defaultUrl == null) {
            return false;
        }
        this.doInclude(httpServletRequest, httpServletResponse, this.defaultUrl);
        return true;
    }

    private void doInclude(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        if (this.contentType != null) {
            httpServletResponse.setContentType(this.contentType);
        }
        String[] stringArray = StringUtils.tokenizeToStringArray((String)string, (String)RESOURCE_URL_DELIMITERS);
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.allowedResources != null && !this.pathMatcher.match(this.allowedResources, stringArray[i])) {
                throw new ServletException("Resource [" + stringArray[i] + "] does not match allowed pattern [" + this.allowedResources + "]");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Including resource [" + stringArray[i] + "]"));
            }
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(stringArray[i]);
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    protected final long getLastModified(HttpServletRequest httpServletRequest) {
        if (this.applyLastModified) {
            String string = this.determineResourceUrl(httpServletRequest);
            if (string == null) {
                string = this.defaultUrl;
            }
            if (string != null) {
                String[] stringArray = StringUtils.tokenizeToStringArray((String)string, (String)RESOURCE_URL_DELIMITERS);
                long l = -1L;
                for (int i = 0; i < stringArray.length; ++i) {
                    long l2 = this.getFileTimestamp(stringArray[i]);
                    if (l2 <= l) continue;
                    l = l2;
                }
                return l > this.startupTime ? l : this.startupTime;
            }
        }
        return -1L;
    }

    protected long getFileTimestamp(String string) {
        try {
            File file = new ServletContextResource(this.getServletContext(), string).getFile();
            long l = file.lastModified();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Last-modified timestamp of resource file [" + file.getAbsolutePath() + "] is [" + l + "]"));
            }
            return l;
        }
        catch (IOException iOException) {
            this.logger.warn((Object)("Couldn't retrieve lastModified timestamp of resource [" + string + "] - returning ResourceServlet startup time"));
            return -1L;
        }
    }
}

