/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.beans.PropertyEditor;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.core.io.ResourceEditor;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResourceLoader;

public abstract class HttpServletBean
extends HttpServlet {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Set requiredProperties = new HashSet();
    static /* synthetic */ Class class$org$springframework$core$io$Resource;

    protected final void addRequiredProperty(String string) {
        this.requiredProperties.add(string);
    }

    public final void init() throws ServletException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Initializing servlet '" + this.getServletName() + "'"));
        }
        try {
            ServletConfigPropertyValues servletConfigPropertyValues = new ServletConfigPropertyValues(this.getServletConfig(), this.requiredProperties);
            BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl((Object)this);
            ServletContextResourceLoader servletContextResourceLoader = new ServletContextResourceLoader(this.getServletContext());
            beanWrapperImpl.registerCustomEditor(class$org$springframework$core$io$Resource == null ? (class$org$springframework$core$io$Resource = HttpServletBean.class$("org.springframework.core.io.Resource")) : class$org$springframework$core$io$Resource, (PropertyEditor)new ResourceEditor((ResourceLoader)servletContextResourceLoader));
            this.initBeanWrapper((BeanWrapper)beanWrapperImpl);
            beanWrapperImpl.setPropertyValues((PropertyValues)servletConfigPropertyValues, true);
        }
        catch (BeansException beansException) {
            this.logger.error((Object)("Failed to set bean properties on servlet '" + this.getServletName() + "'"), (Throwable)beansException);
            throw beansException;
        }
        this.initServletBean();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Servlet '" + this.getServletName() + "' configured successfully"));
        }
    }

    protected void initBeanWrapper(BeanWrapper beanWrapper) throws BeansException {
    }

    public final String getServletName() {
        return this.getServletConfig() != null ? this.getServletConfig().getServletName() : null;
    }

    public final ServletContext getServletContext() {
        return this.getServletConfig() != null ? this.getServletConfig().getServletContext() : null;
    }

    protected void initServletBean() throws ServletException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ServletConfigPropertyValues
    extends MutablePropertyValues {
        public ServletConfigPropertyValues(ServletConfig servletConfig, Set set) throws ServletException {
            HashSet hashSet = set != null && !set.isEmpty() ? new HashSet(set) : null;
            Enumeration enumeration = servletConfig.getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = servletConfig.getInitParameter(string);
                this.addPropertyValue(new PropertyValue(string, (Object)string2));
                if (hashSet == null) continue;
                hashSet.remove(string);
            }
            if (hashSet != null && hashSet.size() > 0) {
                throw new ServletException("Initialization from ServletConfig for servlet '" + servletConfig.getServletName() + "' failed; the following required properties were missing: " + StringUtils.collectionToDelimitedString(hashSet, (String)", "));
            }
        }
    }
}

