/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletRequestHandledEvent;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.HttpServletBean;
import org.springframework.web.util.NestedServletException;
import org.springframework.web.util.WebUtils;

public abstract class FrameworkServlet
extends HttpServletBean
implements ApplicationListener {
    public static final String DEFAULT_NAMESPACE_SUFFIX = "-servlet";
    public static final Class DEFAULT_CONTEXT_CLASS = class$org$springframework$web$context$support$XmlWebApplicationContext == null ? (class$org$springframework$web$context$support$XmlWebApplicationContext = FrameworkServlet.class$("org.springframework.web.context.support.XmlWebApplicationContext")) : class$org$springframework$web$context$support$XmlWebApplicationContext;
    public static final String SERVLET_CONTEXT_PREFIX = (class$org$springframework$web$servlet$FrameworkServlet == null ? (class$org$springframework$web$servlet$FrameworkServlet = FrameworkServlet.class$("org.springframework.web.servlet.FrameworkServlet")) : class$org$springframework$web$servlet$FrameworkServlet).getName() + ".CONTEXT.";
    private Class contextClass = DEFAULT_CONTEXT_CLASS;
    private String namespace;
    private String contextConfigLocation;
    private boolean publishContext = true;
    private boolean publishEvents = true;
    private WebApplicationContext webApplicationContext;
    private boolean refreshEventReceived = false;
    static /* synthetic */ Class class$org$springframework$web$context$support$XmlWebApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$servlet$FrameworkServlet;
    static /* synthetic */ Class class$org$springframework$web$context$ConfigurableWebApplicationContext;

    public void setContextClass(Class clazz) {
        this.contextClass = clazz;
    }

    public Class getContextClass() {
        return this.contextClass;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getNamespace() {
        return this.namespace != null ? this.namespace : this.getServletName() + DEFAULT_NAMESPACE_SUFFIX;
    }

    public void setContextConfigLocation(String string) {
        this.contextConfigLocation = string;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public void setPublishContext(boolean bl) {
        this.publishContext = bl;
    }

    public boolean isPublishContext() {
        return this.publishContext;
    }

    public void setPublishEvents(boolean bl) {
        this.publishEvents = bl;
    }

    public boolean isPublishEvents() {
        return this.publishEvents;
    }

    protected final void initServletBean() throws ServletException, BeansException {
        this.getServletContext().log("Initializing Spring FrameworkServlet '" + this.getServletName() + "'");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("FrameworkServlet '" + this.getServletName() + "': initialization started"));
        }
        long l = System.currentTimeMillis();
        try {
            this.webApplicationContext = this.initWebApplicationContext();
            this.initFrameworkServlet();
        }
        catch (ServletException servletException) {
            this.logger.error((Object)"Context initialization failed", (Throwable)servletException);
            throw servletException;
        }
        catch (BeansException beansException) {
            this.logger.error((Object)"Context initialization failed", (Throwable)beansException);
            throw beansException;
        }
        if (this.logger.isInfoEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            this.logger.info((Object)("FrameworkServlet '" + this.getServletName() + "': initialization completed in " + l2 + " ms"));
        }
    }

    protected WebApplicationContext initWebApplicationContext() throws BeansException {
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        WebApplicationContext webApplicationContext2 = this.createWebApplicationContext(webApplicationContext);
        if (!this.refreshEventReceived) {
            this.onRefresh((ApplicationContext)webApplicationContext2);
        }
        if (this.isPublishContext()) {
            String string = this.getServletContextAttributeName();
            this.getServletContext().setAttribute(string, (Object)webApplicationContext2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Published WebApplicationContext of servlet '" + this.getServletName() + "' as ServletContext attribute with name [" + string + "]"));
            }
        }
        return webApplicationContext2;
    }

    protected WebApplicationContext createWebApplicationContext(WebApplicationContext webApplicationContext) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Servlet with name '" + this.getServletName() + "' will try to create custom WebApplicationContext context of class '" + this.getContextClass().getName() + "'" + ", using parent context [" + webApplicationContext + "]"));
        }
        if (!(class$org$springframework$web$context$ConfigurableWebApplicationContext == null ? (class$org$springframework$web$context$ConfigurableWebApplicationContext = FrameworkServlet.class$("org.springframework.web.context.ConfigurableWebApplicationContext")) : class$org$springframework$web$context$ConfigurableWebApplicationContext).isAssignableFrom(this.getContextClass())) {
            throw new ApplicationContextException("Fatal initialization error in servlet with name '" + this.getServletName() + "': custom WebApplicationContext class [" + this.getContextClass().getName() + "] is not of type ConfigurableWebApplicationContext");
        }
        ConfigurableWebApplicationContext configurableWebApplicationContext = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass((Class)this.getContextClass());
        configurableWebApplicationContext.setParent((ApplicationContext)webApplicationContext);
        configurableWebApplicationContext.setServletContext(this.getServletContext());
        configurableWebApplicationContext.setServletConfig(this.getServletConfig());
        configurableWebApplicationContext.setNamespace(this.getNamespace());
        if (this.getContextConfigLocation() != null) {
            configurableWebApplicationContext.setConfigLocations(StringUtils.tokenizeToStringArray((String)this.getContextConfigLocation(), (String)",; \t\n"));
        }
        configurableWebApplicationContext.addApplicationListener((ApplicationListener)this);
        configurableWebApplicationContext.refresh();
        return configurableWebApplicationContext;
    }

    public String getServletContextAttributeName() {
        return SERVLET_CONTEXT_PREFIX + this.getServletName();
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected void initFrameworkServlet() throws ServletException, BeansException {
    }

    public void refresh() throws BeansException {
        WebApplicationContext webApplicationContext = this.getWebApplicationContext();
        if (!(webApplicationContext instanceof ConfigurableApplicationContext)) {
            throw new IllegalStateException("WebApplicationContext does not support refresh: " + webApplicationContext);
        }
        ((ConfigurableApplicationContext)webApplicationContext).refresh();
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ContextRefreshedEvent) {
            this.refreshEventReceived = true;
            this.onRefresh(((ContextRefreshedEvent)applicationEvent).getApplicationContext());
        }
    }

    protected void onRefresh(ApplicationContext applicationContext) throws BeansException {
    }

    protected final void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected final void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected final void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected final void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Throwable throwable;
        long l;
        block11: {
            block9: {
                l = System.currentTimeMillis();
                throwable = null;
                try {
                    try {
                        this.doService(httpServletRequest, httpServletResponse);
                    }
                    catch (ServletException servletException) {
                        throwable = servletException;
                        throw servletException;
                    }
                    catch (IOException iOException) {
                        throwable = iOException;
                        throw iOException;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw new NestedServletException("Request processing failed", throwable3);
                    }
                    Object var8_5 = null;
                    if (throwable == null) break block9;
                }
                catch (Throwable throwable2) {
                    Object var8_6 = null;
                    if (throwable != null) {
                        this.logger.debug((Object)"Could not complete request", throwable);
                    } else {
                        this.logger.debug((Object)"Successfully completed request");
                    }
                    if (!this.isPublishEvents()) throw throwable2;
                    long l2 = System.currentTimeMillis() - l;
                    this.webApplicationContext.publishEvent((ApplicationEvent)new ServletRequestHandledEvent((Object)this, httpServletRequest.getRequestURI(), httpServletRequest.getRemoteAddr(), httpServletRequest.getMethod(), this.getServletConfig().getServletName(), WebUtils.getSessionId((HttpServletRequest)httpServletRequest), this.getUsernameForRequest(httpServletRequest), l2, throwable));
                    throw throwable2;
                }
                this.logger.debug((Object)"Could not complete request", throwable);
                break block11;
            }
            this.logger.debug((Object)"Successfully completed request");
        }
        if (!this.isPublishEvents()) return;
        long l3 = System.currentTimeMillis() - l;
        this.webApplicationContext.publishEvent((ApplicationEvent)new ServletRequestHandledEvent((Object)this, httpServletRequest.getRequestURI(), httpServletRequest.getRemoteAddr(), httpServletRequest.getMethod(), this.getServletConfig().getServletName(), WebUtils.getSessionId((HttpServletRequest)httpServletRequest), this.getUsernameForRequest(httpServletRequest), l3, throwable));
    }

    protected String getUsernameForRequest(HttpServletRequest httpServletRequest) {
        Principal principal = httpServletRequest.getUserPrincipal();
        return principal != null ? principal.getName() : null;
    }

    protected abstract void doService(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public void destroy() {
        this.getServletContext().log("Destroying Spring FrameworkServlet '" + this.getServletName() + "'");
        if (this.webApplicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.webApplicationContext).close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

