/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.ui.context.ThemeSource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.RequestToViewNameTranslator;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class DispatcherServlet
extends FrameworkServlet {
    public static final String MULTIPART_RESOLVER_BEAN_NAME = "multipartResolver";
    public static final String LOCALE_RESOLVER_BEAN_NAME = "localeResolver";
    public static final String THEME_RESOLVER_BEAN_NAME = "themeResolver";
    public static final String HANDLER_MAPPING_BEAN_NAME = "handlerMapping";
    public static final String HANDLER_ADAPTER_BEAN_NAME = "handlerAdapter";
    public static final String HANDLER_EXCEPTION_RESOLVER_BEAN_NAME = "handlerExceptionResolver";
    public static final String REQUEST_TO_VIEW_NAME_TRANSLATOR_BEAN_NAME = "viewNameTranslator";
    public static final String VIEW_RESOLVER_BEAN_NAME = "viewResolver";
    public static final String HANDLER_EXECUTION_CHAIN_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".HANDLER";
    public static final String WEB_APPLICATION_CONTEXT_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".CONTEXT";
    public static final String LOCALE_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".LOCALE_RESOLVER";
    public static final String THEME_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".THEME_RESOLVER";
    public static final String THEME_SOURCE_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".THEME_SOURCE";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    private static final String DEFAULT_STRATEGIES_PATH = "DispatcherServlet.properties";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private static final Properties defaultStrategies;
    private boolean detectAllHandlerMappings = true;
    private boolean detectAllHandlerAdapters = true;
    private boolean detectAllHandlerExceptionResolvers = true;
    private boolean detectAllViewResolvers = true;
    private boolean cleanupAfterInclude = true;
    private boolean threadContextInheritable = false;
    private MultipartResolver multipartResolver;
    private LocaleResolver localeResolver;
    private ThemeResolver themeResolver;
    private List handlerMappings;
    private List handlerAdapters;
    private List handlerExceptionResolvers;
    private RequestToViewNameTranslator viewNameTranslator;
    private List viewResolvers;
    static /* synthetic */ Class class$org$springframework$web$servlet$DispatcherServlet;
    static /* synthetic */ Class class$org$springframework$web$multipart$MultipartResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$LocaleResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$ThemeResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerMapping;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerAdapter;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerExceptionResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$RequestToViewNameTranslator;
    static /* synthetic */ Class class$org$springframework$web$servlet$ViewResolver;

    public void setDetectAllHandlerMappings(boolean bl) {
        this.detectAllHandlerMappings = bl;
    }

    public void setDetectAllHandlerAdapters(boolean bl) {
        this.detectAllHandlerAdapters = bl;
    }

    public void setDetectAllHandlerExceptionResolvers(boolean bl) {
        this.detectAllHandlerExceptionResolvers = bl;
    }

    public void setDetectAllViewResolvers(boolean bl) {
        this.detectAllViewResolvers = bl;
    }

    public void setCleanupAfterInclude(boolean bl) {
        this.cleanupAfterInclude = bl;
    }

    public void setThreadContextInheritable(boolean bl) {
        this.threadContextInheritable = bl;
    }

    protected void onRefresh(ApplicationContext applicationContext) throws BeansException {
        this.initStrategies(applicationContext);
    }

    protected void initStrategies(ApplicationContext applicationContext) {
        this.initMultipartResolver(applicationContext);
        this.initLocaleResolver(applicationContext);
        this.initThemeResolver(applicationContext);
        this.initHandlerMappings(applicationContext);
        this.initHandlerAdapters(applicationContext);
        this.initHandlerExceptionResolvers(applicationContext);
        this.initRequestToViewNameTranslator(applicationContext);
        this.initViewResolvers(applicationContext);
    }

    private void initMultipartResolver(ApplicationContext applicationContext) {
        block3: {
            try {
                this.multipartResolver = (MultipartResolver)applicationContext.getBean(MULTIPART_RESOLVER_BEAN_NAME, class$org$springframework$web$multipart$MultipartResolver == null ? (class$org$springframework$web$multipart$MultipartResolver = DispatcherServlet.class$("org.springframework.web.multipart.MultipartResolver")) : class$org$springframework$web$multipart$MultipartResolver);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using MultipartResolver [" + this.multipartResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                this.multipartResolver = null;
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)"Unable to locate MultipartResolver with name 'multipartResolver': no multipart request handling provided");
            }
        }
    }

    private void initLocaleResolver(ApplicationContext applicationContext) {
        block3: {
            try {
                this.localeResolver = (LocaleResolver)applicationContext.getBean(LOCALE_RESOLVER_BEAN_NAME, class$org$springframework$web$servlet$LocaleResolver == null ? (class$org$springframework$web$servlet$LocaleResolver = DispatcherServlet.class$("org.springframework.web.servlet.LocaleResolver")) : class$org$springframework$web$servlet$LocaleResolver);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using LocaleResolver [" + this.localeResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                this.localeResolver = (LocaleResolver)this.getDefaultStrategy(applicationContext, class$org$springframework$web$servlet$LocaleResolver == null ? (class$org$springframework$web$servlet$LocaleResolver = DispatcherServlet.class$("org.springframework.web.servlet.LocaleResolver")) : class$org$springframework$web$servlet$LocaleResolver);
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("Unable to locate LocaleResolver with name 'localeResolver': using default [" + this.localeResolver + "]"));
            }
        }
    }

    private void initThemeResolver(ApplicationContext applicationContext) {
        block3: {
            try {
                this.themeResolver = (ThemeResolver)applicationContext.getBean(THEME_RESOLVER_BEAN_NAME, class$org$springframework$web$servlet$ThemeResolver == null ? (class$org$springframework$web$servlet$ThemeResolver = DispatcherServlet.class$("org.springframework.web.servlet.ThemeResolver")) : class$org$springframework$web$servlet$ThemeResolver);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using ThemeResolver [" + this.themeResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                this.themeResolver = (ThemeResolver)this.getDefaultStrategy(applicationContext, class$org$springframework$web$servlet$ThemeResolver == null ? (class$org$springframework$web$servlet$ThemeResolver = DispatcherServlet.class$("org.springframework.web.servlet.ThemeResolver")) : class$org$springframework$web$servlet$ThemeResolver);
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("Unable to locate ThemeResolver with name 'themeResolver': using default [" + this.themeResolver + "]"));
            }
        }
    }

    private void initHandlerMappings(ApplicationContext applicationContext) {
        this.handlerMappings = null;
        if (this.detectAllHandlerMappings) {
            Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, (Class)(class$org$springframework$web$servlet$HandlerMapping == null ? (class$org$springframework$web$servlet$HandlerMapping = DispatcherServlet.class$("org.springframework.web.servlet.HandlerMapping")) : class$org$springframework$web$servlet$HandlerMapping), (boolean)true, (boolean)false);
            if (!map.isEmpty()) {
                this.handlerMappings = new ArrayList(map.values());
                Collections.sort(this.handlerMappings, new OrderComparator());
            }
        } else {
            try {
                Object object = applicationContext.getBean(HANDLER_MAPPING_BEAN_NAME, class$org$springframework$web$servlet$HandlerMapping == null ? (class$org$springframework$web$servlet$HandlerMapping = DispatcherServlet.class$("org.springframework.web.servlet.HandlerMapping")) : class$org$springframework$web$servlet$HandlerMapping);
                this.handlerMappings = Collections.singletonList(object);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerMappings == null) {
            this.handlerMappings = this.getDefaultStrategies(applicationContext, class$org$springframework$web$servlet$HandlerMapping == null ? (class$org$springframework$web$servlet$HandlerMapping = DispatcherServlet.class$("org.springframework.web.servlet.HandlerMapping")) : class$org$springframework$web$servlet$HandlerMapping);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerMappings found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initHandlerAdapters(ApplicationContext applicationContext) {
        this.handlerAdapters = null;
        if (this.detectAllHandlerAdapters) {
            Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, (Class)(class$org$springframework$web$servlet$HandlerAdapter == null ? (class$org$springframework$web$servlet$HandlerAdapter = DispatcherServlet.class$("org.springframework.web.servlet.HandlerAdapter")) : class$org$springframework$web$servlet$HandlerAdapter), (boolean)true, (boolean)false);
            if (!map.isEmpty()) {
                this.handlerAdapters = new ArrayList(map.values());
                Collections.sort(this.handlerAdapters, new OrderComparator());
            }
        } else {
            try {
                Object object = applicationContext.getBean(HANDLER_ADAPTER_BEAN_NAME, class$org$springframework$web$servlet$HandlerAdapter == null ? (class$org$springframework$web$servlet$HandlerAdapter = DispatcherServlet.class$("org.springframework.web.servlet.HandlerAdapter")) : class$org$springframework$web$servlet$HandlerAdapter);
                this.handlerAdapters = Collections.singletonList(object);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerAdapters == null) {
            this.handlerAdapters = this.getDefaultStrategies(applicationContext, class$org$springframework$web$servlet$HandlerAdapter == null ? (class$org$springframework$web$servlet$HandlerAdapter = DispatcherServlet.class$("org.springframework.web.servlet.HandlerAdapter")) : class$org$springframework$web$servlet$HandlerAdapter);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerAdapters found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initHandlerExceptionResolvers(ApplicationContext applicationContext) {
        this.handlerExceptionResolvers = null;
        if (this.detectAllHandlerExceptionResolvers) {
            Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, (Class)(class$org$springframework$web$servlet$HandlerExceptionResolver == null ? (class$org$springframework$web$servlet$HandlerExceptionResolver = DispatcherServlet.class$("org.springframework.web.servlet.HandlerExceptionResolver")) : class$org$springframework$web$servlet$HandlerExceptionResolver), (boolean)true, (boolean)false);
            if (!map.isEmpty()) {
                this.handlerExceptionResolvers = new ArrayList(map.values());
                Collections.sort(this.handlerExceptionResolvers, new OrderComparator());
            }
        } else {
            try {
                Object object = applicationContext.getBean(HANDLER_EXCEPTION_RESOLVER_BEAN_NAME, class$org$springframework$web$servlet$HandlerExceptionResolver == null ? (class$org$springframework$web$servlet$HandlerExceptionResolver = DispatcherServlet.class$("org.springframework.web.servlet.HandlerExceptionResolver")) : class$org$springframework$web$servlet$HandlerExceptionResolver);
                this.handlerExceptionResolvers = Collections.singletonList(object);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerExceptionResolvers == null) {
            this.handlerExceptionResolvers = this.getDefaultStrategies(applicationContext, class$org$springframework$web$servlet$HandlerExceptionResolver == null ? (class$org$springframework$web$servlet$HandlerExceptionResolver = DispatcherServlet.class$("org.springframework.web.servlet.HandlerExceptionResolver")) : class$org$springframework$web$servlet$HandlerExceptionResolver);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerExceptionResolvers found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initRequestToViewNameTranslator(ApplicationContext applicationContext) {
        block3: {
            try {
                this.viewNameTranslator = (RequestToViewNameTranslator)applicationContext.getBean(REQUEST_TO_VIEW_NAME_TRANSLATOR_BEAN_NAME, class$org$springframework$web$servlet$RequestToViewNameTranslator == null ? (class$org$springframework$web$servlet$RequestToViewNameTranslator = DispatcherServlet.class$("org.springframework.web.servlet.RequestToViewNameTranslator")) : class$org$springframework$web$servlet$RequestToViewNameTranslator);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using RequestToViewNameTranslator [" + this.viewNameTranslator + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                this.viewNameTranslator = (RequestToViewNameTranslator)this.getDefaultStrategy(applicationContext, class$org$springframework$web$servlet$RequestToViewNameTranslator == null ? (class$org$springframework$web$servlet$RequestToViewNameTranslator = DispatcherServlet.class$("org.springframework.web.servlet.RequestToViewNameTranslator")) : class$org$springframework$web$servlet$RequestToViewNameTranslator);
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("Unable to locate RequestToViewNameTranslator with name 'viewNameTranslator': using default [" + this.viewNameTranslator + "]"));
            }
        }
    }

    private void initViewResolvers(ApplicationContext applicationContext) {
        this.viewResolvers = null;
        if (this.detectAllViewResolvers) {
            Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, (Class)(class$org$springframework$web$servlet$ViewResolver == null ? (class$org$springframework$web$servlet$ViewResolver = DispatcherServlet.class$("org.springframework.web.servlet.ViewResolver")) : class$org$springframework$web$servlet$ViewResolver), (boolean)true, (boolean)false);
            if (!map.isEmpty()) {
                this.viewResolvers = new ArrayList(map.values());
                Collections.sort(this.viewResolvers, new OrderComparator());
            }
        } else {
            try {
                Object object = applicationContext.getBean(VIEW_RESOLVER_BEAN_NAME, class$org$springframework$web$servlet$ViewResolver == null ? (class$org$springframework$web$servlet$ViewResolver = DispatcherServlet.class$("org.springframework.web.servlet.ViewResolver")) : class$org$springframework$web$servlet$ViewResolver);
                this.viewResolvers = Collections.singletonList(object);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.viewResolvers == null) {
            this.viewResolvers = this.getDefaultStrategies(applicationContext, class$org$springframework$web$servlet$ViewResolver == null ? (class$org$springframework$web$servlet$ViewResolver = DispatcherServlet.class$("org.springframework.web.servlet.ViewResolver")) : class$org$springframework$web$servlet$ViewResolver);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No ViewResolvers found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    public ThemeSource getThemeSource() {
        if (this.getWebApplicationContext() instanceof ThemeSource) {
            return (ThemeSource)this.getWebApplicationContext();
        }
        return null;
    }

    protected Object getDefaultStrategy(ApplicationContext applicationContext, Class clazz) throws BeansException {
        List list = this.getDefaultStrategies(applicationContext, clazz);
        if (list.size() != 1) {
            throw new BeanInitializationException("DispatcherServlet needs exactly 1 strategy for interface [" + clazz.getName() + "]");
        }
        return list.get(0);
    }

    protected List getDefaultStrategies(ApplicationContext applicationContext, Class clazz) throws BeansException {
        String string = clazz.getName();
        ArrayList<Object> arrayList = null;
        String string2 = defaultStrategies.getProperty(string);
        if (string2 != null) {
            String[] stringArray = StringUtils.commaDelimitedListToStringArray((String)string2);
            arrayList = new ArrayList<Object>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                try {
                    Class clazz2 = ClassUtils.forName((String)string3, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                    Object object = this.createDefaultStrategy(applicationContext, clazz2);
                    arrayList.add(object);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new BeanInitializationException("Could not find DispatcherServlet's default strategy class [" + string3 + "] for interface [" + string + "]", (Throwable)classNotFoundException);
                }
                catch (LinkageError linkageError) {
                    throw new BeanInitializationException("Error loading DispatcherServlet's default strategy class [" + string3 + "] for interface [" + string + "]: problem with class file or dependent class", (Throwable)linkageError);
                }
            }
        } else {
            arrayList = Collections.EMPTY_LIST;
        }
        return arrayList;
    }

    protected Object createDefaultStrategy(ApplicationContext applicationContext, Class clazz) throws BeansException {
        return applicationContext.getAutowireCapableBeanFactory().createBean(clazz, 0, false);
    }

    public MultipartResolver getMultipartResolver() {
        return this.multipartResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DispatcherServlet with name '" + this.getServletName() + "' received request for [" + httpServletRequest.getRequestURI() + "]"));
        }
        HashMap<String, Object> hashMap = null;
        if (WebUtils.isIncludeRequest((ServletRequest)httpServletRequest)) {
            this.logger.debug((Object)"Taking snapshot of request attributes before include");
            hashMap = new HashMap<String, Object>();
            Enumeration enumeration = httpServletRequest.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!this.cleanupAfterInclude && !string.startsWith((class$org$springframework$web$servlet$DispatcherServlet == null ? DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet") : class$org$springframework$web$servlet$DispatcherServlet).getName())) continue;
                hashMap.put(string, httpServletRequest.getAttribute(string));
            }
        }
        httpServletRequest.setAttribute(WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.getWebApplicationContext());
        httpServletRequest.setAttribute(LOCALE_RESOLVER_ATTRIBUTE, (Object)this.localeResolver);
        httpServletRequest.setAttribute(THEME_RESOLVER_ATTRIBUTE, (Object)this.themeResolver);
        httpServletRequest.setAttribute(THEME_SOURCE_ATTRIBUTE, (Object)this.getThemeSource());
        try {
            this.doDispatch(httpServletRequest, httpServletResponse);
        }
        finally {
            if (hashMap != null) {
                this.restoreAttributesAfterInclude(httpServletRequest, hashMap);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void doDispatch(HttpServletRequest var1_1, HttpServletResponse var2_2) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        try {
            HandlerExecutionChain handlerExecutionChain = this.getHandler(httpServletRequest, true);
            if (handlerExecutionChain == null || handlerExecutionChain.getHandler() == null) {
                this.logger.debug((Object)"No handler found in getLastModified");
                return -1L;
            }
            HandlerAdapter handlerAdapter = this.getHandlerAdapter(handlerExecutionChain.getHandler());
            long l = handlerAdapter.getLastModified(httpServletRequest, handlerExecutionChain.getHandler());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Last-Modified value for [" + httpServletRequest.getRequestURI() + "] is [" + l + "]"));
            }
            return l;
        }
        catch (Exception exception) {
            this.logger.debug((Object)"Exception thrown in getLastModified", (Throwable)exception);
            return -1L;
        }
    }

    protected LocaleContext buildLocaleContext(final HttpServletRequest httpServletRequest) {
        return new LocaleContext(){

            public Locale getLocale() {
                return DispatcherServlet.this.localeResolver.resolveLocale(httpServletRequest);
            }
        };
    }

    protected HttpServletRequest checkMultipart(HttpServletRequest httpServletRequest) throws MultipartException {
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(httpServletRequest)) {
            if (httpServletRequest instanceof MultipartHttpServletRequest) {
                this.logger.debug((Object)"Request is already a MultipartHttpServletRequest - if not in a forward, this typically results from an additional MultipartFilter in web.xml");
            } else {
                return this.multipartResolver.resolveMultipart(httpServletRequest);
            }
        }
        return httpServletRequest;
    }

    protected void cleanupMultipart(HttpServletRequest httpServletRequest) {
        if (httpServletRequest instanceof MultipartHttpServletRequest) {
            this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)httpServletRequest);
        }
    }

    protected HandlerExecutionChain getHandler(HttpServletRequest httpServletRequest, boolean bl) throws Exception {
        HandlerExecutionChain handlerExecutionChain = (HandlerExecutionChain)httpServletRequest.getAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE);
        if (handlerExecutionChain != null) {
            if (!bl) {
                httpServletRequest.removeAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE);
            }
            return handlerExecutionChain;
        }
        Iterator iterator = this.handlerMappings.iterator();
        while (iterator.hasNext()) {
            HandlerMapping handlerMapping = (HandlerMapping)iterator.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler map [" + handlerMapping + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
            }
            if ((handlerExecutionChain = handlerMapping.getHandler(httpServletRequest)) == null) continue;
            if (bl) {
                httpServletRequest.setAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE, (Object)handlerExecutionChain);
            }
            return handlerExecutionChain;
        }
        return null;
    }

    protected void noHandlerFound(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (pageNotFoundLogger.isWarnEnabled()) {
            String string = new UrlPathHelper().getRequestUri(httpServletRequest);
            pageNotFoundLogger.warn((Object)("No mapping for [" + string + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
        }
        httpServletResponse.sendError(404);
    }

    protected HandlerAdapter getHandlerAdapter(Object object) throws ServletException {
        Iterator iterator = this.handlerAdapters.iterator();
        while (iterator.hasNext()) {
            HandlerAdapter handlerAdapter = (HandlerAdapter)iterator.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler adapter [" + handlerAdapter + "]"));
            }
            if (!handlerAdapter.supports(object)) continue;
            return handlerAdapter;
        }
        throw new ServletException("No adapter for handler [" + object + "]: Does your handler implement a supported interface like Controller?");
    }

    protected ModelAndView processHandlerException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, Exception exception) throws Exception {
        ModelAndView modelAndView = null;
        Iterator iterator = this.handlerExceptionResolvers.iterator();
        while (modelAndView == null && iterator.hasNext()) {
            HandlerExceptionResolver handlerExceptionResolver = (HandlerExceptionResolver)iterator.next();
            modelAndView = handlerExceptionResolver.resolveException(httpServletRequest, httpServletResponse, object, exception);
        }
        if (modelAndView != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Handler execution resulted in exception - forwarding to resolved error view: " + modelAndView), (Throwable)exception);
            }
            return modelAndView;
        }
        throw exception;
    }

    protected void render(ModelAndView modelAndView, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Locale locale = this.localeResolver.resolveLocale(httpServletRequest);
        httpServletResponse.setLocale(locale);
        View view = null;
        if (!modelAndView.hasView()) {
            modelAndView.setViewName(this.getDefaultViewName(httpServletRequest));
        }
        if (modelAndView.isReference()) {
            view = this.resolveViewName(modelAndView.getViewName(), modelAndView.getModelInternal(), locale, httpServletRequest);
            if (view == null) {
                throw new ServletException("Could not resolve view with name '" + modelAndView.getViewName() + "' in servlet with name '" + this.getServletName() + "'");
            }
        } else {
            view = modelAndView.getView();
            if (view == null) {
                throw new ServletException("ModelAndView [" + modelAndView + "] neither contains a view name nor a " + "View object in servlet with name '" + this.getServletName() + "'");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering view [" + view + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
        }
        view.render(modelAndView.getModelInternal(), httpServletRequest, httpServletResponse);
    }

    protected String getDefaultViewName(HttpServletRequest httpServletRequest) throws Exception {
        String string = this.viewNameTranslator.getViewName(httpServletRequest);
        if (string == null) {
            throw new ServletException("Could not translate request [" + httpServletRequest + "] into view name using [" + this.viewNameTranslator.getClass().getName() + "]");
        }
        return string;
    }

    protected View resolveViewName(String string, Map map, Locale locale, HttpServletRequest httpServletRequest) throws Exception {
        Iterator iterator = this.viewResolvers.iterator();
        while (iterator.hasNext()) {
            ViewResolver viewResolver = (ViewResolver)iterator.next();
            View view = viewResolver.resolveViewName(string, locale);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    private void triggerAfterCompletion(HandlerExecutionChain handlerExecutionChain, int n, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) throws Exception {
        if (handlerExecutionChain != null && handlerExecutionChain.getInterceptors() != null) {
            for (int i = n; i >= 0; --i) {
                HandlerInterceptor handlerInterceptor = handlerExecutionChain.getInterceptors()[i];
                try {
                    handlerInterceptor.afterCompletion(httpServletRequest, httpServletResponse, handlerExecutionChain.getHandler(), exception);
                    continue;
                }
                catch (Throwable throwable) {
                    this.logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", throwable);
                }
            }
        }
    }

    private void restoreAttributesAfterInclude(HttpServletRequest httpServletRequest, Map map) {
        Object object;
        this.logger.debug((Object)"Restoring snapshot of request attributes after include");
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.cleanupAfterInclude && !((String)object).startsWith((class$org$springframework$web$servlet$DispatcherServlet == null ? DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet") : class$org$springframework$web$servlet$DispatcherServlet).getName())) continue;
            hashSet.add(object);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            Object v = map.get(string);
            if (v != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Restoring original value of attribute [" + string + "] after include"));
                }
                httpServletRequest.setAttribute(string, v);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing attribute [" + string + "] after include"));
            }
            httpServletRequest.removeAttribute(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            ClassPathResource classPathResource = new ClassPathResource(DEFAULT_STRATEGIES_PATH, class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet);
            defaultStrategies = PropertiesLoaderUtils.loadProperties((Resource)classPathResource);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not load 'DispatcherServlet.properties': " + iOException.getMessage());
        }
    }
}

