/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.rowset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.springframework.jdbc.InvalidResultSetAccessException;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public class ResultSetWrappingSqlRowSetMetaData
implements SqlRowSetMetaData {
    private final ResultSetMetaData resultSetMetaData;
    private String[] columnNames;

    public ResultSetWrappingSqlRowSetMetaData(ResultSetMetaData resultSetMetaData) {
        this.resultSetMetaData = resultSetMetaData;
    }

    public String getCatalogName(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.getCatalogName(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public String getColumnClassName(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.getColumnClassName(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public int getColumnCount() throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public String[] getColumnNames() throws InvalidResultSetAccessException {
        if (this.columnNames == null) {
            this.columnNames = new String[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.columnNames[i] = this.getColumnName(i + 1);
            }
        }
        return this.columnNames;
    }

    public int getColumnDisplaySize(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.getColumnDisplaySize(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public String getColumnLabel(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.getColumnLabel(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public String getColumnName(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.getColumnName(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public int getColumnType(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.getColumnType(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public String getColumnTypeName(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.getColumnTypeName(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public int getPrecision(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.getPrecision(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public int getScale(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.getScale(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public String getSchemaName(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.getSchemaName(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public String getTableName(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.getTableName(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean isCaseSensitive(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.isCaseSensitive(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean isCurrency(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.isCurrency(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean isSigned(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSetMetaData.isSigned(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }
}

