/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.rowset;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.springframework.jdbc.InvalidResultSetAccessException;
import org.springframework.jdbc.support.rowset.ResultSetWrappingSqlRowSetMetaData;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public class ResultSetWrappingSqlRowSet
implements SqlRowSet {
    private final ResultSet resultSet;
    private final SqlRowSetMetaData rowSetMetaData;

    public ResultSetWrappingSqlRowSet(ResultSet resultSet) throws InvalidResultSetAccessException {
        this.resultSet = resultSet;
        try {
            this.rowSetMetaData = new ResultSetWrappingSqlRowSetMetaData(resultSet.getMetaData());
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public SqlRowSetMetaData getMetaData() {
        return this.rowSetMetaData;
    }

    public int findColumn(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public BigDecimal getBigDecimal(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getBigDecimal(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public BigDecimal getBigDecimal(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getBigDecimal(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean getBoolean(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getBoolean(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean getBoolean(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getBoolean(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public byte getByte(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getByte(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public byte getByte(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getByte(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Date getDate(int n, Calendar calendar) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getDate(n, calendar);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Date getDate(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getDate(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Date getDate(String string, Calendar calendar) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getDate(string, calendar);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Date getDate(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getDate(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public double getDouble(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getDouble(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public double getDouble(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getDouble(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public float getFloat(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getFloat(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public float getFloat(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getFloat(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public int getInt(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getInt(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public int getInt(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getInt(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public long getLong(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getLong(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public long getLong(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getLong(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Object getObject(int n, Map map) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getObject(n, map);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Object getObject(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getObject(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Object getObject(String string, Map map) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getObject(string, map);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Object getObject(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getObject(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public short getShort(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getShort(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public short getShort(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getShort(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public String getString(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getString(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public String getString(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getString(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Time getTime(int n, Calendar calendar) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTime(n, calendar);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Time getTime(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTime(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Time getTime(String string, Calendar calendar) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTime(string, calendar);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Time getTime(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTime(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Timestamp getTimestamp(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTimestamp(string, calendar);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public Timestamp getTimestamp(String string) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTimestamp(string);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean absolute(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.absolute(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public void afterLast() throws InvalidResultSetAccessException {
        try {
            this.resultSet.afterLast();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public void beforeFirst() throws InvalidResultSetAccessException {
        try {
            this.resultSet.beforeFirst();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean first() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.first();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public int getRow() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getRow();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean isAfterLast() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.isAfterLast();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean isBeforeFirst() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.isBeforeFirst();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean isFirst() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.isFirst();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean isLast() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.isLast();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean last() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.last();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean next() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.next();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean previous() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.previous();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean relative(int n) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.relative(n);
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }

    public boolean wasNull() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.wasNull();
        }
        catch (SQLException sQLException) {
            throw new InvalidResultSetAccessException(sQLException);
        }
    }
}

