/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import org.springframework.util.ReflectionUtils;

public class WebLogicNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String JDBC_EXTENSION_NAME = "weblogic.jdbc.extensions.WLConnection";
    private final Class jdbcExtensionClass;
    private final Method getVendorConnectionMethod;

    public WebLogicNativeJdbcExtractor() {
        try {
            this.jdbcExtensionClass = this.getClass().getClassLoader().loadClass(JDBC_EXTENSION_NAME);
            this.getVendorConnectionMethod = this.jdbcExtensionClass.getMethod("getVendorConnection", null);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not initialize WebLogicNativeJdbcExtractor because WebLogic API classes are not available: " + exception);
        }
    }

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    protected Connection doGetNativeConnection(Connection connection) throws SQLException {
        if (this.jdbcExtensionClass.isAssignableFrom(connection.getClass())) {
            return (Connection)ReflectionUtils.invokeMethod((Method)this.getVendorConnectionMethod, (Object)connection);
        }
        return connection;
    }
}

