/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public abstract class NativeJdbcExtractorAdapter
implements NativeJdbcExtractor {
    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return false;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return false;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return false;
    }

    public Connection getNativeConnection(Connection connection) throws SQLException {
        Connection connection2;
        DatabaseMetaData databaseMetaData;
        if (connection == null) {
            return null;
        }
        Connection connection3 = DataSourceUtils.getTargetConnection(connection);
        Connection connection4 = this.doGetNativeConnection(connection3);
        if (connection4 == connection3 && (databaseMetaData = connection3.getMetaData()) != null && (connection2 = databaseMetaData.getConnection()) != connection3) {
            connection4 = this.doGetNativeConnection(connection2);
        }
        return connection4;
    }

    protected Connection doGetNativeConnection(Connection connection) throws SQLException {
        return connection;
    }

    public Connection getNativeConnectionFromStatement(Statement statement) throws SQLException {
        if (statement == null) {
            return null;
        }
        return this.getNativeConnection(statement.getConnection());
    }

    public Statement getNativeStatement(Statement statement) throws SQLException {
        return statement;
    }

    public PreparedStatement getNativePreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        return preparedStatement;
    }

    public CallableStatement getNativeCallableStatement(CallableStatement callableStatement) throws SQLException {
        return callableStatement;
    }

    public ResultSet getNativeResultSet(ResultSet resultSet) throws SQLException {
        return resultSet;
    }
}

