/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import org.springframework.util.ReflectionUtils;

public class JBossNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String WRAPPED_CONNECTION_NAME = "org.jboss.resource.adapter.jdbc.WrappedConnection";
    private static final String WRAPPED_STATEMENT_NAME = "org.jboss.resource.adapter.jdbc.WrappedStatement";
    private static final String WRAPPED_RESULT_SET_NAME = "org.jboss.resource.adapter.jdbc.WrappedResultSet";
    private Class wrappedConnectionClass;
    private Class wrappedStatementClass;
    private Class wrappedResultSetClass;
    private Method getUnderlyingConnectionMethod;
    private Method getUnderlyingStatementMethod;
    private Method getUnderlyingResultSetMethod;

    public JBossNativeJdbcExtractor() {
        try {
            this.wrappedConnectionClass = this.getClass().getClassLoader().loadClass(WRAPPED_CONNECTION_NAME);
            this.wrappedStatementClass = this.getClass().getClassLoader().loadClass(WRAPPED_STATEMENT_NAME);
            this.wrappedResultSetClass = this.getClass().getClassLoader().loadClass(WRAPPED_RESULT_SET_NAME);
            this.getUnderlyingConnectionMethod = this.wrappedConnectionClass.getMethod("getUnderlyingConnection", null);
            this.getUnderlyingStatementMethod = this.wrappedStatementClass.getMethod("getUnderlyingStatement", null);
            this.getUnderlyingResultSetMethod = this.wrappedResultSetClass.getMethod("getUnderlyingResultSet", null);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not initialize JBossNativeJdbcExtractor because JBoss API classes are not available: " + exception);
        }
    }

    protected Connection doGetNativeConnection(Connection connection) throws SQLException {
        if (this.wrappedConnectionClass.isAssignableFrom(connection.getClass())) {
            return (Connection)ReflectionUtils.invokeMethod((Method)this.getUnderlyingConnectionMethod, (Object)connection);
        }
        return connection;
    }

    public Statement getNativeStatement(Statement statement) throws SQLException {
        if (this.wrappedStatementClass.isAssignableFrom(statement.getClass())) {
            return (Statement)ReflectionUtils.invokeMethod((Method)this.getUnderlyingStatementMethod, (Object)statement);
        }
        return statement;
    }

    public PreparedStatement getNativePreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        return (PreparedStatement)this.getNativeStatement(preparedStatement);
    }

    public CallableStatement getNativeCallableStatement(CallableStatement callableStatement) throws SQLException {
        return (CallableStatement)this.getNativeStatement(callableStatement);
    }

    public ResultSet getNativeResultSet(ResultSet resultSet) throws SQLException {
        if (this.wrappedResultSetClass.isAssignableFrom(resultSet.getClass())) {
            return (ResultSet)ReflectionUtils.invokeMethod((Method)this.getUnderlyingResultSetMethod, (Object)resultSet);
        }
        return resultSet;
    }
}

