/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import org.springframework.util.ReflectionUtils;

public class CommonsDbcpNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String GET_INNERMOST_DELEGATE_METHOD_NAME = "getInnermostDelegate";

    private static Object getInnermostDelegate(Object object) {
        if (object == null) {
            return null;
        }
        try {
            Class<?> clazz = object.getClass();
            while (!Modifier.isPublic(clazz.getModifiers())) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                return object;
            }
            Method method = clazz.getMethod(GET_INNERMOST_DELEGATE_METHOD_NAME, null);
            Object object2 = ReflectionUtils.invokeMethod((Method)method, (Object)object);
            return object2 != null ? object2 : object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return object;
        }
        catch (SecurityException securityException) {
            throw new IllegalStateException("Commons DBCP getInnermostDelegate method is not accessible: " + securityException);
        }
    }

    protected Connection doGetNativeConnection(Connection connection) throws SQLException {
        return (Connection)CommonsDbcpNativeJdbcExtractor.getInnermostDelegate(connection);
    }

    public Statement getNativeStatement(Statement statement) throws SQLException {
        return (Statement)CommonsDbcpNativeJdbcExtractor.getInnermostDelegate(statement);
    }

    public PreparedStatement getNativePreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        return (PreparedStatement)this.getNativeStatement(preparedStatement);
    }

    public CallableStatement getNativeCallableStatement(CallableStatement callableStatement) throws SQLException {
        return (CallableStatement)this.getNativeStatement(callableStatement);
    }

    public ResultSet getNativeResultSet(ResultSet resultSet) throws SQLException {
        return (ResultSet)CommonsDbcpNativeJdbcExtractor.getInnermostDelegate(resultSet);
    }
}

