/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import com.mchange.v2.c3p0.C3P0ProxyConnection;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import org.springframework.util.ReflectionUtils;

public class C3P0NativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private final Method getRawConnectionMethod;
    static /* synthetic */ Class class$java$sql$Connection;

    public static Connection getRawConnection(Connection connection) {
        return connection;
    }

    public C3P0NativeJdbcExtractor() {
        try {
            this.getRawConnectionMethod = this.getClass().getMethod("getRawConnection", class$java$sql$Connection == null ? (class$java$sql$Connection = C3P0NativeJdbcExtractor.class$("java.sql.Connection")) : class$java$sql$Connection);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("Internal error in C3P0NativeJdbcExtractor: " + noSuchMethodException.getMessage());
        }
    }

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    protected Connection doGetNativeConnection(Connection connection) throws SQLException {
        if (connection instanceof C3P0ProxyConnection) {
            C3P0ProxyConnection c3P0ProxyConnection = (C3P0ProxyConnection)connection;
            try {
                return (Connection)c3P0ProxyConnection.rawConnectionOperation(this.getRawConnectionMethod, null, new Object[]{C3P0ProxyConnection.RAW_CONNECTION});
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                ReflectionUtils.handleReflectionException((Exception)exception);
            }
        }
        return connection;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

