/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.lob.AbstractLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.util.FileCopyUtils;

public class OracleLobHandler
extends AbstractLobHandler {
    private static final String BLOB_CLASS_NAME = "oracle.sql.BLOB";
    private static final String CLOB_CLASS_NAME = "oracle.sql.CLOB";
    private static final String DURATION_SESSION_FIELD_NAME = "DURATION_SESSION";
    private static final String MODE_READWRITE_FIELD_NAME = "MODE_READWRITE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private NativeJdbcExtractor nativeJdbcExtractor;
    private Boolean cache = Boolean.TRUE;
    private Class blobClass;
    private Class clobClass;
    private final Map durationSessionConstants = new HashMap(2);
    private final Map modeReadWriteConstants = new HashMap(2);
    static /* synthetic */ Class class$java$sql$Connection;

    public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
        this.nativeJdbcExtractor = nativeJdbcExtractor;
    }

    public void setCache(boolean bl) {
        this.cache = new Boolean(bl);
    }

    protected synchronized void initOracleDriverClasses(Connection connection) {
        if (this.blobClass == null) {
            try {
                this.blobClass = connection.getClass().getClassLoader().loadClass(BLOB_CLASS_NAME);
                this.durationSessionConstants.put(this.blobClass, new Integer(this.blobClass.getField(DURATION_SESSION_FIELD_NAME).getInt(null)));
                this.modeReadWriteConstants.put(this.blobClass, new Integer(this.blobClass.getField(MODE_READWRITE_FIELD_NAME).getInt(null)));
                this.clobClass = connection.getClass().getClassLoader().loadClass(CLOB_CLASS_NAME);
                this.durationSessionConstants.put(this.clobClass, new Integer(this.clobClass.getField(DURATION_SESSION_FIELD_NAME).getInt(null)));
                this.modeReadWriteConstants.put(this.clobClass, new Integer(this.clobClass.getField(MODE_READWRITE_FIELD_NAME).getInt(null)));
            }
            catch (Exception exception) {
                throw new InvalidDataAccessApiUsageException("Couldn't initialize OracleLobHandler because Oracle driver classes are not available. Note that OracleLobHandler requires Oracle JDBC driver 9i or higher!", (Throwable)exception);
            }
        }
    }

    public byte[] getBlobAsBytes(ResultSet resultSet, int n) throws SQLException {
        this.logger.debug((Object)"Returning Oracle BLOB as bytes");
        Blob blob = resultSet.getBlob(n);
        return blob != null ? blob.getBytes(1L, (int)blob.length()) : null;
    }

    public InputStream getBlobAsBinaryStream(ResultSet resultSet, int n) throws SQLException {
        this.logger.debug((Object)"Returning Oracle BLOB as binary stream");
        Blob blob = resultSet.getBlob(n);
        return blob != null ? blob.getBinaryStream() : null;
    }

    public String getClobAsString(ResultSet resultSet, int n) throws SQLException {
        this.logger.debug((Object)"Returning Oracle CLOB as string");
        Clob clob = resultSet.getClob(n);
        return clob != null ? clob.getSubString(1L, (int)clob.length()) : null;
    }

    public InputStream getClobAsAsciiStream(ResultSet resultSet, int n) throws SQLException {
        this.logger.debug((Object)"Returning Oracle CLOB as ASCII stream");
        Clob clob = resultSet.getClob(n);
        return clob != null ? clob.getAsciiStream() : null;
    }

    public Reader getClobAsCharacterStream(ResultSet resultSet, int n) throws SQLException {
        this.logger.debug((Object)"Returning Oracle CLOB as character stream");
        Clob clob = resultSet.getClob(n);
        return clob != null ? clob.getCharacterStream() : null;
    }

    public LobCreator getLobCreator() {
        return new OracleLobCreator();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static interface LobCallback {
        public void populateLob(Object var1) throws Exception;
    }

    protected class OracleLobCreator
    implements LobCreator {
        private final List createdLobs = new LinkedList();

        protected OracleLobCreator() {
        }

        public void setBlobAsBytes(PreparedStatement preparedStatement, int n, final byte[] byArray) throws SQLException {
            if (byArray != null) {
                Blob blob = (Blob)this.createLob(preparedStatement, false, new LobCallback(){

                    public void populateLob(Object object) throws Exception {
                        Method method = object.getClass().getMethod("getBinaryOutputStream", new Class[0]);
                        OutputStream outputStream = (OutputStream)method.invoke(object, (Object[])null);
                        FileCopyUtils.copy((byte[])byArray, (OutputStream)outputStream);
                    }
                });
                preparedStatement.setBlob(n, blob);
                if (OracleLobHandler.this.logger.isDebugEnabled()) {
                    OracleLobHandler.this.logger.debug((Object)("Set bytes for Oracle BLOB with length " + blob.length()));
                }
            } else {
                preparedStatement.setBlob(n, (Blob)null);
                OracleLobHandler.this.logger.debug((Object)"Set Oracle BLOB to null");
            }
        }

        public void setBlobAsBinaryStream(PreparedStatement preparedStatement, int n, final InputStream inputStream, int n2) throws SQLException {
            if (inputStream != null) {
                Blob blob = (Blob)this.createLob(preparedStatement, false, new LobCallback(){

                    public void populateLob(Object object) throws Exception {
                        Method method = object.getClass().getMethod("getBinaryOutputStream", null);
                        OutputStream outputStream = (OutputStream)method.invoke(object, (Object[])null);
                        FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    }
                });
                preparedStatement.setBlob(n, blob);
                if (OracleLobHandler.this.logger.isDebugEnabled()) {
                    OracleLobHandler.this.logger.debug((Object)("Set binary stream for Oracle BLOB with length " + blob.length()));
                }
            } else {
                preparedStatement.setBlob(n, (Blob)null);
                OracleLobHandler.this.logger.debug((Object)"Set Oracle BLOB to null");
            }
        }

        public void setClobAsString(PreparedStatement preparedStatement, int n, final String string) throws SQLException {
            if (string != null) {
                Clob clob = (Clob)this.createLob(preparedStatement, true, new LobCallback(){

                    public void populateLob(Object object) throws Exception {
                        Method method = object.getClass().getMethod("getCharacterOutputStream", null);
                        Writer writer = (Writer)method.invoke(object, (Object[])null);
                        FileCopyUtils.copy((String)string, (Writer)writer);
                    }
                });
                preparedStatement.setClob(n, clob);
                if (OracleLobHandler.this.logger.isDebugEnabled()) {
                    OracleLobHandler.this.logger.debug((Object)("Set string for Oracle CLOB with length " + clob.length()));
                }
            } else {
                preparedStatement.setClob(n, (Clob)null);
                OracleLobHandler.this.logger.debug((Object)"Set Oracle CLOB to null");
            }
        }

        public void setClobAsAsciiStream(PreparedStatement preparedStatement, int n, final InputStream inputStream, int n2) throws SQLException {
            if (inputStream != null) {
                Clob clob = (Clob)this.createLob(preparedStatement, true, new LobCallback(){

                    public void populateLob(Object object) throws Exception {
                        Method method = object.getClass().getMethod("getAsciiOutputStream", null);
                        OutputStream outputStream = (OutputStream)method.invoke(object, (Object[])null);
                        FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    }
                });
                preparedStatement.setClob(n, clob);
                if (OracleLobHandler.this.logger.isDebugEnabled()) {
                    OracleLobHandler.this.logger.debug((Object)("Set ASCII stream for Oracle CLOB with length " + clob.length()));
                }
            } else {
                preparedStatement.setClob(n, (Clob)null);
                OracleLobHandler.this.logger.debug((Object)"Set Oracle CLOB to null");
            }
        }

        public void setClobAsCharacterStream(PreparedStatement preparedStatement, int n, final Reader reader, int n2) throws SQLException {
            if (reader != null) {
                Clob clob = (Clob)this.createLob(preparedStatement, true, new LobCallback(){

                    public void populateLob(Object object) throws Exception {
                        Method method = object.getClass().getMethod("getCharacterOutputStream", null);
                        Writer writer = (Writer)method.invoke(object, (Object[])null);
                        FileCopyUtils.copy((Reader)reader, (Writer)writer);
                    }
                });
                preparedStatement.setClob(n, clob);
                if (OracleLobHandler.this.logger.isDebugEnabled()) {
                    OracleLobHandler.this.logger.debug((Object)("Set character stream for Oracle CLOB with length " + clob.length()));
                }
            } else {
                preparedStatement.setClob(n, (Clob)null);
                OracleLobHandler.this.logger.debug((Object)"Set Oracle CLOB to null");
            }
        }

        protected Object createLob(PreparedStatement preparedStatement, boolean bl, LobCallback lobCallback) throws SQLException {
            Connection connection = null;
            try {
                connection = this.getOracleConnection(preparedStatement);
                OracleLobHandler.this.initOracleDriverClasses(connection);
                Object object = this.prepareLob(connection, bl ? OracleLobHandler.this.clobClass : OracleLobHandler.this.blobClass);
                lobCallback.populateLob(object);
                object.getClass().getMethod("close", null).invoke(object, (Object[])null);
                this.createdLobs.add(object);
                if (OracleLobHandler.this.logger.isDebugEnabled()) {
                    OracleLobHandler.this.logger.debug((Object)("Created new Oracle " + (bl ? "CLOB" : "BLOB")));
                }
                return object;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof SQLException) {
                    throw (SQLException)invocationTargetException.getTargetException();
                }
                if (connection != null && invocationTargetException.getTargetException() instanceof ClassCastException) {
                    throw new InvalidDataAccessApiUsageException("OracleLobCreator needs to work on [oracle.jdbc.OracleConnection], not on [" + connection.getClass().getName() + "]: specify a corresponding NativeJdbcExtractor", invocationTargetException.getTargetException());
                }
                throw new DataAccessResourceFailureException("Could not create Oracle LOB", invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new DataAccessResourceFailureException("Could not create Oracle LOB", (Throwable)exception);
            }
        }

        protected Connection getOracleConnection(PreparedStatement preparedStatement) throws SQLException, ClassNotFoundException {
            return OracleLobHandler.this.nativeJdbcExtractor != null ? OracleLobHandler.this.nativeJdbcExtractor.getNativeConnectionFromStatement(preparedStatement) : preparedStatement.getConnection();
        }

        protected Object prepareLob(Connection connection, Class clazz) throws Exception {
            Method method = clazz.getMethod("createTemporary", class$java$sql$Connection == null ? (class$java$sql$Connection = OracleLobHandler.class$("java.sql.Connection")) : class$java$sql$Connection, Boolean.TYPE, Integer.TYPE);
            Object object = method.invoke(null, connection, OracleLobHandler.this.cache, OracleLobHandler.this.durationSessionConstants.get(clazz));
            Method method2 = clazz.getMethod("open", Integer.TYPE);
            method2.invoke(object, OracleLobHandler.this.modeReadWriteConstants.get(clazz));
            return object;
        }

        public void close() {
            try {
                Iterator iterator = this.createdLobs.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Method method = e.getClass().getMethod("freeTemporary", new Class[0]);
                    method.invoke(e, new Object[0]);
                    iterator.remove();
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                OracleLobHandler.this.logger.error((Object)"Could not free Oracle LOB", invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new DataAccessResourceFailureException("Could not free Oracle LOB", (Throwable)exception);
            }
        }
    }
}

