/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.support.lob.JtaLobCreatorSynchronization;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.SpringLobCreatorSynchronization;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class LobCreatorUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$support$lob$LobCreatorUtils == null ? (class$org$springframework$jdbc$support$lob$LobCreatorUtils = LobCreatorUtils.class$("org.springframework.jdbc.support.lob.LobCreatorUtils")) : class$org$springframework$jdbc$support$lob$LobCreatorUtils));
    static /* synthetic */ Class class$org$springframework$jdbc$support$lob$LobCreatorUtils;

    public static void registerTransactionSynchronization(LobCreator lobCreator, TransactionManager transactionManager) throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            if (transactionManager != null) {
                try {
                    int n = transactionManager.getStatus();
                    if (n == 0 || n == 1) {
                        logger.debug((Object)"Registering JTA transaction synchronization for LobCreator");
                        transactionManager.getTransaction().registerSynchronization((Synchronization)new JtaLobCreatorSynchronization(lobCreator));
                        return;
                    }
                }
                catch (Throwable throwable) {
                    throw new TransactionSystemException("Could not register synchronization with JTA TransactionManager", throwable);
                }
            }
            throw new IllegalStateException("Active Spring transaction synchronization or active JTA transaction with specified [javax.transaction.TransactionManager] required");
        }
        logger.debug((Object)"Registering Spring transaction synchronization for LobCreator");
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringLobCreatorSynchronization(lobCreator));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

