/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import javax.transaction.Synchronization;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.util.Assert;

public class JtaLobCreatorSynchronization
implements Synchronization {
    private final LobCreator lobCreator;
    private boolean beforeCompletionCalled = false;

    public JtaLobCreatorSynchronization(LobCreator lobCreator) {
        Assert.notNull((Object)lobCreator, (String)"LobCreator must not be null");
        this.lobCreator = lobCreator;
    }

    public void beforeCompletion() {
        this.beforeCompletionCalled = true;
        this.lobCreator.close();
    }

    public void afterCompletion(int n) {
        if (!this.beforeCompletionCalled) {
            this.lobCreator.close();
        }
    }
}

