/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.support.lob.AbstractLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;

public class DefaultLobHandler
extends AbstractLobHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public byte[] getBlobAsBytes(ResultSet resultSet, int n) throws SQLException {
        this.logger.debug((Object)"Returning BLOB as bytes");
        return resultSet.getBytes(n);
    }

    public InputStream getBlobAsBinaryStream(ResultSet resultSet, int n) throws SQLException {
        this.logger.debug((Object)"Returning BLOB as binary stream");
        return resultSet.getBinaryStream(n);
    }

    public String getClobAsString(ResultSet resultSet, int n) throws SQLException {
        this.logger.debug((Object)"Returning CLOB as string");
        return resultSet.getString(n);
    }

    public InputStream getClobAsAsciiStream(ResultSet resultSet, int n) throws SQLException {
        this.logger.debug((Object)"Returning CLOB as ASCII stream");
        return resultSet.getAsciiStream(n);
    }

    public Reader getClobAsCharacterStream(ResultSet resultSet, int n) throws SQLException {
        this.logger.debug((Object)"Returning CLOB as character stream");
        return resultSet.getCharacterStream(n);
    }

    public LobCreator getLobCreator() {
        this.logger.debug((Object)"Creating new DefaultLobCreator");
        return new DefaultLobCreator();
    }

    protected class DefaultLobCreator
    implements LobCreator {
        protected DefaultLobCreator() {
        }

        public void setBlobAsBytes(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
            preparedStatement.setBytes(n, byArray);
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug((Object)(byArray != null ? "Set bytes for BLOB with length " + byArray.length : "Set BLOB to null"));
            }
        }

        public void setBlobAsBinaryStream(PreparedStatement preparedStatement, int n, InputStream inputStream, int n2) throws SQLException {
            preparedStatement.setBinaryStream(n, inputStream, n2);
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug((Object)(inputStream != null ? "Set binary stream for BLOB with length " + n2 : "Set BLOB to null"));
            }
        }

        public void setClobAsString(PreparedStatement preparedStatement, int n, String string) throws SQLException {
            preparedStatement.setString(n, string);
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug((Object)(string != null ? "Set string for CLOB with length " + string.length() : "Set CLOB to null"));
            }
        }

        public void setClobAsAsciiStream(PreparedStatement preparedStatement, int n, InputStream inputStream, int n2) throws SQLException {
            preparedStatement.setAsciiStream(n, inputStream, n2);
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug((Object)(inputStream != null ? "Set ASCII stream for CLOB with length " + n2 : "Set CLOB to null"));
            }
        }

        public void setClobAsCharacterStream(PreparedStatement preparedStatement, int n, Reader reader, int n2) throws SQLException {
            preparedStatement.setCharacterStream(n, reader, n2);
            if (DefaultLobHandler.this.logger.isDebugEnabled()) {
                DefaultLobHandler.this.logger.debug((Object)(reader != null ? "Set character stream for CLOB with length " + n2 : "Set CLOB to null"));
            }
        }

        public void close() {
            DefaultLobHandler.this.logger.debug((Object)"Closing DefaultLobCreator");
        }
    }
}

