/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;

public class MySQLMaxValueIncrementer
extends AbstractDataFieldMaxValueIncrementer {
    private static final String VALUE_SQL = "select last_insert_id()";
    private String columnName;
    private int cacheSize = 1;
    private long nextId = 0L;
    private long maxId = 0L;

    public MySQLMaxValueIncrementer() {
    }

    public MySQLMaxValueIncrementer(DataSource dataSource, String string, String string2) {
        this.setDataSource(dataSource);
        this.setIncrementerName(string);
        this.columnName = string2;
        this.afterPropertiesSet();
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.columnName == null) {
            throw new IllegalArgumentException("columnName is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long getNextKey() throws DataAccessException {
        if (this.maxId == this.nextId) {
            Connection connection = DataSourceUtils.getConnection(this.getDataSource());
            Statement statement = null;
            try {
                statement = connection.createStatement();
                DataSourceUtils.applyTransactionTimeout(statement, this.getDataSource());
                statement.executeUpdate("update " + this.getIncrementerName() + " set " + this.columnName + " = last_insert_id(" + this.columnName + " + " + this.getCacheSize() + ")");
                ResultSet resultSet = statement.executeQuery(VALUE_SQL);
                try {
                    if (!resultSet.next()) {
                        throw new DataAccessResourceFailureException("last_insert_id() failed after executing an update");
                    }
                    this.maxId = resultSet.getLong(1);
                }
                finally {
                    JdbcUtils.closeResultSet(resultSet);
                }
                this.nextId = this.maxId - (long)this.getCacheSize() + 1L;
            }
            catch (SQLException sQLException) {
                throw new DataAccessResourceFailureException("Could not obtain last_insert_id()", (Throwable)sQLException);
            }
            finally {
                JdbcUtils.closeStatement(statement);
                DataSourceUtils.releaseConnection(connection, this.getDataSource());
            }
        }
        ++this.nextId;
        return this.nextId;
    }
}

