/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;

public class HsqlMaxValueIncrementer
extends AbstractDataFieldMaxValueIncrementer {
    private String columnName;
    private int cacheSize = 1;
    private long[] valueCache = null;
    private int nextValueIndex = -1;

    public HsqlMaxValueIncrementer() {
    }

    public HsqlMaxValueIncrementer(DataSource dataSource, String string, String string2) {
        this.setDataSource(dataSource);
        this.setIncrementerName(string);
        this.columnName = string2;
        this.afterPropertiesSet();
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.columnName == null) {
            throw new IllegalArgumentException("columnName is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long getNextKey() throws DataAccessException {
        if (this.nextValueIndex < 0 || this.nextValueIndex >= this.getCacheSize()) {
            Connection connection = DataSourceUtils.getConnection(this.getDataSource());
            Statement statement = null;
            try {
                statement = connection.createStatement();
                DataSourceUtils.applyTransactionTimeout(statement, this.getDataSource());
                this.valueCache = new long[this.getCacheSize()];
                this.nextValueIndex = 0;
                for (int i = 0; i < this.getCacheSize(); ++i) {
                    statement.executeUpdate("insert into " + this.getIncrementerName() + " values(null)");
                    ResultSet resultSet = statement.executeQuery("select max(identity()) from " + this.getIncrementerName());
                    try {
                        if (!resultSet.next()) {
                            throw new DataAccessResourceFailureException("identity() failed after executing an update");
                        }
                        this.valueCache[i] = resultSet.getLong(1);
                        continue;
                    }
                    finally {
                        JdbcUtils.closeResultSet(resultSet);
                    }
                }
                long l = this.valueCache[this.valueCache.length - 1];
                statement.executeUpdate("delete from " + this.getIncrementerName() + " where " + this.columnName + " < " + l);
            }
            catch (SQLException sQLException) {
                throw new DataAccessResourceFailureException("Could not obtain identity()", (Throwable)sQLException);
            }
            finally {
                JdbcUtils.closeStatement(statement);
                DataSourceUtils.releaseConnection(connection, this.getDataSource());
            }
        }
        return this.valueCache[this.nextValueIndex++];
    }
}

