/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;

public abstract class AbstractSequenceMaxValueIncrementer
extends AbstractDataFieldMaxValueIncrementer {
    protected long getNextKey() throws DataAccessException {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block5: {
            connection = DataSourceUtils.getConnection(this.getDataSource());
            statement = null;
            resultSet = null;
            statement = connection.createStatement();
            DataSourceUtils.applyTransactionTimeout(statement, this.getDataSource());
            resultSet = statement.executeQuery(this.getSequenceQuery());
            if (!resultSet.next()) break block5;
            long l = resultSet.getLong(1);
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            DataSourceUtils.releaseConnection(connection, this.getDataSource());
            return l;
        }
        try {
            try {
                throw new DataAccessResourceFailureException("Sequence query did not return a result");
            }
            catch (SQLException sQLException) {
                throw new DataAccessResourceFailureException("Could not obtain sequence value", (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            DataSourceUtils.releaseConnection(connection, this.getDataSource());
            throw throwable;
        }
    }

    protected abstract String getSequenceQuery();
}

