/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public abstract class AbstractDataFieldMaxValueIncrementer
implements DataFieldMaxValueIncrementer,
InitializingBean {
    private DataSource dataSource;
    private String incrementerName;
    protected int paddingLength = 0;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setIncrementerName(String string) {
        this.incrementerName = string;
    }

    public String getIncrementerName() {
        return this.incrementerName;
    }

    public void setPaddingLength(int n) {
        this.paddingLength = n;
    }

    public int getPaddingLength() {
        return this.paddingLength;
    }

    public void afterPropertiesSet() {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("dataSource is required");
        }
        if (this.incrementerName == null) {
            throw new IllegalArgumentException("incrementerName is required");
        }
    }

    public int nextIntValue() throws DataAccessException {
        return (int)this.getNextKey();
    }

    public long nextLongValue() throws DataAccessException {
        return this.getNextKey();
    }

    public String nextStringValue() throws DataAccessException {
        String string = Long.toString(this.getNextKey());
        int n = string.length();
        if (n < this.paddingLength) {
            StringBuffer stringBuffer = new StringBuffer(this.paddingLength);
            for (int i = 0; i < this.paddingLength - n; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            string = stringBuffer.toString();
        }
        return string;
    }

    protected abstract long getNextKey();
}

