/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.util.Assert;

public class SQLStateSQLExceptionTranslator
implements SQLExceptionTranslator {
    private static final Set BAD_SQL_CODES = new HashSet(6);
    private static final Set INTEGRITY_VIOLATION_CODES = new HashSet(4);
    private static final Set RESOURCE_FAILURE_CODES = new HashSet(3);
    private static final Set CONCURRENCY_CODES = new HashSet(1);
    protected final Log logger = LogFactory.getLog(this.getClass());

    public DataAccessException translate(String string, String string2, SQLException sQLException) {
        String string3;
        Assert.notNull((Object)sQLException, (String)"Cannot translate a null SQLException.");
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((string3 = this.getSqlState(sQLException)) != null && string3.length() >= 2) {
            String string4 = string3.substring(0, 2);
            if (BAD_SQL_CODES.contains(string4)) {
                return new BadSqlGrammarException(string, string2, sQLException);
            }
            if (INTEGRITY_VIOLATION_CODES.contains(string4)) {
                return new DataIntegrityViolationException(this.buildMessage(string, string2, sQLException), (Throwable)sQLException);
            }
            if (RESOURCE_FAILURE_CODES.contains(string4)) {
                return new DataAccessResourceFailureException(this.buildMessage(string, string2, sQLException), (Throwable)sQLException);
            }
            if (CONCURRENCY_CODES.contains(string4)) {
                return new ConcurrencyFailureException(this.buildMessage(string, string2, sQLException), (Throwable)sQLException);
            }
        }
        return new UncategorizedSQLException(string, string2, sQLException);
    }

    protected String buildMessage(String string, String string2, SQLException sQLException) {
        return string + "; SQL [" + string2 + "]; " + sQLException.getMessage();
    }

    private String getSqlState(SQLException sQLException) {
        SQLException sQLException2;
        String string = sQLException.getSQLState();
        if (string == null && (sQLException2 = sQLException.getNextException()) != null) {
            string = sQLException2.getSQLState();
        }
        return string;
    }

    static {
        BAD_SQL_CODES.add("07");
        BAD_SQL_CODES.add("37");
        BAD_SQL_CODES.add("42");
        BAD_SQL_CODES.add("2A");
        BAD_SQL_CODES.add("65");
        BAD_SQL_CODES.add("S0");
        INTEGRITY_VIOLATION_CODES.add("22");
        INTEGRITY_VIOLATION_CODES.add("23");
        INTEGRITY_VIOLATION_CODES.add("27");
        INTEGRITY_VIOLATION_CODES.add("44");
        CONCURRENCY_CODES.add("40");
        RESOURCE_FAILURE_CODES.add("08");
        RESOURCE_FAILURE_CODES.add("53");
        RESOURCE_FAILURE_CODES.add("54");
    }
}

