/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.SQLErrorCodes;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public class SQLErrorCodesFactory {
    public static final String SQL_ERROR_CODE_OVERRIDE_PATH = "sql-error-codes.xml";
    public static final String SQL_ERROR_CODE_DEFAULT_PATH = "org/springframework/jdbc/support/sql-error-codes.xml";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$support$SQLErrorCodesFactory == null ? (class$org$springframework$jdbc$support$SQLErrorCodesFactory = SQLErrorCodesFactory.class$("org.springframework.jdbc.support.SQLErrorCodesFactory")) : class$org$springframework$jdbc$support$SQLErrorCodesFactory));
    private static final SQLErrorCodesFactory instance = new SQLErrorCodesFactory();
    private final Map errorCodesMap;
    private final Map dataSourceCache = new HashMap(16);
    static /* synthetic */ Class class$org$springframework$jdbc$support$SQLErrorCodesFactory;
    static /* synthetic */ Class class$org$springframework$jdbc$support$SQLErrorCodes;

    public static SQLErrorCodesFactory getInstance() {
        return instance;
    }

    protected SQLErrorCodesFactory() {
        Map map = null;
        try {
            DefaultListableBeanFactory defaultListableBeanFactory = new DefaultListableBeanFactory();
            XmlBeanDefinitionReader xmlBeanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)defaultListableBeanFactory);
            Resource resource = this.loadResource(SQL_ERROR_CODE_DEFAULT_PATH);
            if (resource != null && resource.exists()) {
                xmlBeanDefinitionReader.loadBeanDefinitions(resource);
            } else {
                logger.warn((Object)"Default sql-error-codes.xml not found (should be included in spring.jar)");
            }
            resource = this.loadResource(SQL_ERROR_CODE_OVERRIDE_PATH);
            if (resource != null && resource.exists()) {
                xmlBeanDefinitionReader.loadBeanDefinitions(resource);
                logger.info((Object)"Found custom sql-error-codes.xml file at the root of the classpath");
            }
            map = defaultListableBeanFactory.getBeansOfType(class$org$springframework$jdbc$support$SQLErrorCodes == null ? (class$org$springframework$jdbc$support$SQLErrorCodes = SQLErrorCodesFactory.class$("org.springframework.jdbc.support.SQLErrorCodes")) : class$org$springframework$jdbc$support$SQLErrorCodes, true, false);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("SQLErrorCodes loaded: " + map.keySet()));
            }
        }
        catch (BeansException beansException) {
            logger.warn((Object)"Error loading SQL error codes from config file", (Throwable)beansException);
            map = Collections.EMPTY_MAP;
        }
        this.errorCodesMap = map;
    }

    protected Resource loadResource(String string) {
        return new ClassPathResource(string);
    }

    public SQLErrorCodes getErrorCodes(String string) {
        Assert.notNull((Object)string, (String)"Database product name must not be null");
        SQLErrorCodes sQLErrorCodes = (SQLErrorCodes)this.errorCodesMap.get(string);
        if (sQLErrorCodes == null) {
            Iterator iterator = this.errorCodesMap.values().iterator();
            while (iterator.hasNext()) {
                SQLErrorCodes sQLErrorCodes2 = (SQLErrorCodes)iterator.next();
                if (!PatternMatchUtils.simpleMatch((String[])sQLErrorCodes2.getDatabaseProductNames(), (String)string)) continue;
                sQLErrorCodes = sQLErrorCodes2;
                break;
            }
        }
        if (sQLErrorCodes != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SQL error codes for '" + string + "' found"));
            }
            return sQLErrorCodes;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SQL error codes for '" + string + "' not found"));
        }
        return new SQLErrorCodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLErrorCodes getErrorCodes(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"DataSource must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking up default SQLErrorCodes for DataSource [" + dataSource + "]"));
        }
        Map map = this.dataSourceCache;
        synchronized (map) {
            SQLErrorCodes sQLErrorCodes = (SQLErrorCodes)this.dataSourceCache.get(dataSource);
            if (sQLErrorCodes != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("SQLErrorCodes found in cache for DataSource [" + dataSource + "]"));
                }
                return sQLErrorCodes;
            }
            try {
                String string = (String)JdbcUtils.extractDatabaseMetaData(dataSource, "getDatabaseProductName");
                if (string != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Database product name cached for DataSource [" + dataSource + "]: name is '" + string + "'"));
                    }
                    sQLErrorCodes = this.getErrorCodes(string);
                    this.dataSourceCache.put(dataSource, sQLErrorCodes);
                    return sQLErrorCodes;
                }
            }
            catch (MetaDataAccessException metaDataAccessException) {
                logger.warn((Object)"Error while extracting database product name - falling back to empty error codes", (Throwable)((Object)metaDataAccessException));
            }
        }
        return new SQLErrorCodes();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

