/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.CannotSerializeTransactionException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.InvalidResultSetAccessException;
import org.springframework.jdbc.support.CustomSQLErrorCodesTranslation;
import org.springframework.jdbc.support.SQLErrorCodes;
import org.springframework.jdbc.support.SQLErrorCodesFactory;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

public class SQLErrorCodeSQLExceptionTranslator
implements SQLExceptionTranslator {
    private static final int MESSAGE_ONLY_CONSTRUCTOR = 1;
    private static final int MESSAGE_THROWABLE_CONSTRUCTOR = 2;
    private static final int MESSAGE_SQLEX_CONSTRUCTOR = 3;
    private static final int MESSAGE_SQL_THROWABLE_CONSTRUCTOR = 4;
    private static final int MESSAGE_SQL_SQLEX_CONSTRUCTOR = 5;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SQLErrorCodes sqlErrorCodes;
    private SQLExceptionTranslator fallbackTranslator = new SQLStateSQLExceptionTranslator();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$sql$SQLException;

    public SQLErrorCodeSQLExceptionTranslator() {
    }

    public SQLErrorCodeSQLExceptionTranslator(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public SQLErrorCodeSQLExceptionTranslator(String string) {
        this.setDatabaseProductName(string);
    }

    public SQLErrorCodeSQLExceptionTranslator(SQLErrorCodes sQLErrorCodes) {
        this.sqlErrorCodes = sQLErrorCodes;
    }

    public void setDataSource(DataSource dataSource) {
        this.sqlErrorCodes = SQLErrorCodesFactory.getInstance().getErrorCodes(dataSource);
    }

    public void setDatabaseProductName(String string) {
        this.sqlErrorCodes = SQLErrorCodesFactory.getInstance().getErrorCodes(string);
    }

    public void setSqlErrorCodes(SQLErrorCodes sQLErrorCodes) {
        this.sqlErrorCodes = sQLErrorCodes;
    }

    public SQLErrorCodes getSqlErrorCodes() {
        return this.sqlErrorCodes;
    }

    public void setFallbackTranslator(SQLExceptionTranslator sQLExceptionTranslator) {
        this.fallbackTranslator = sQLExceptionTranslator;
    }

    public SQLExceptionTranslator getFallbackTranslator() {
        return this.fallbackTranslator;
    }

    public DataAccessException translate(String string, String string2, SQLException sQLException) {
        String string3;
        DataAccessException dataAccessException;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((dataAccessException = this.customTranslate(string, string2, sQLException)) != null) {
            return dataAccessException;
        }
        if (this.sqlErrorCodes != null) {
            string3 = null;
            string3 = this.sqlErrorCodes.isUseSqlStateForTranslation() ? sQLException.getSQLState() : Integer.toString(sQLException.getErrorCode());
            if (string3 != null) {
                CustomSQLErrorCodesTranslation[] customSQLErrorCodesTranslationArray = this.sqlErrorCodes.getCustomTranslations();
                if (customSQLErrorCodesTranslationArray != null) {
                    for (int i = 0; i < customSQLErrorCodesTranslationArray.length; ++i) {
                        DataAccessException dataAccessException2;
                        CustomSQLErrorCodesTranslation customSQLErrorCodesTranslation = customSQLErrorCodesTranslationArray[i];
                        if (Arrays.binarySearch(customSQLErrorCodesTranslation.getErrorCodes(), string3) < 0 || customSQLErrorCodesTranslation.getExceptionClass() == null || (dataAccessException2 = this.createCustomException(string, string2, sQLException, customSQLErrorCodesTranslation.getExceptionClass())) == null) continue;
                        this.logTranslation(string, string2, sQLException, true);
                        return dataAccessException2;
                    }
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getBadSqlGrammarCodes(), string3) >= 0) {
                    this.logTranslation(string, string2, sQLException, false);
                    return new BadSqlGrammarException(string, string2, sQLException);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getInvalidResultSetAccessCodes(), string3) >= 0) {
                    this.logTranslation(string, string2, sQLException, false);
                    return new InvalidResultSetAccessException(string, string2, sQLException);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getDataAccessResourceFailureCodes(), string3) >= 0) {
                    this.logTranslation(string, string2, sQLException, false);
                    return new DataAccessResourceFailureException(this.buildMessage(string, string2, sQLException), (Throwable)sQLException);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getPermissionDeniedCodes(), string3) >= 0) {
                    this.logTranslation(string, string2, sQLException, false);
                    return new PermissionDeniedDataAccessException(this.buildMessage(string, string2, sQLException), (Throwable)sQLException);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getDataIntegrityViolationCodes(), string3) >= 0) {
                    this.logTranslation(string, string2, sQLException, false);
                    return new DataIntegrityViolationException(this.buildMessage(string, string2, sQLException), (Throwable)sQLException);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getCannotAcquireLockCodes(), string3) >= 0) {
                    this.logTranslation(string, string2, sQLException, false);
                    return new CannotAcquireLockException(this.buildMessage(string, string2, sQLException), (Throwable)sQLException);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getDeadlockLoserCodes(), string3) >= 0) {
                    this.logTranslation(string, string2, sQLException, false);
                    return new DeadlockLoserDataAccessException(this.buildMessage(string, string2, sQLException), (Throwable)sQLException);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getCannotSerializeTransactionCodes(), string3) >= 0) {
                    this.logTranslation(string, string2, sQLException, false);
                    return new CannotSerializeTransactionException(this.buildMessage(string, string2, sQLException), (Throwable)sQLException);
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            string3 = null;
            string3 = this.sqlErrorCodes.isUseSqlStateForTranslation() ? "SQL state '" + sQLException.getSQLState() + "', error code '" + sQLException.getErrorCode() : "Error code '" + sQLException.getErrorCode() + "'";
            this.logger.debug((Object)("Unable to translate SQLException with " + string3 + ", will now try the fallback translator"));
        }
        return this.fallbackTranslator.translate(string, string2, sQLException);
    }

    protected String buildMessage(String string, String string2, SQLException sQLException) {
        return string + "; SQL [" + string2 + "]; " + sQLException.getMessage();
    }

    protected DataAccessException customTranslate(String string, String string2, SQLException sQLException) {
        return null;
    }

    protected DataAccessException createCustomException(String string, String string2, SQLException sQLException, Class clazz) {
        try {
            Class<?>[] classArray;
            int n = 0;
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                classArray = constructorArray[i].getParameterTypes();
                if (classArray.length == 1 && classArray[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && n < 1) {
                    n = 1;
                }
                if (classArray.length == 2 && classArray[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && classArray[1].equals(class$java$lang$Throwable == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.Throwable") : class$java$lang$Throwable) && n < 2) {
                    n = 2;
                }
                if (classArray.length == 2 && classArray[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && classArray[1].equals(class$java$sql$SQLException == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.sql.SQLException") : class$java$sql$SQLException) && n < 3) {
                    n = 3;
                }
                if (classArray.length == 3 && classArray[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && classArray[1].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) && classArray[2].equals(class$java$lang$Throwable == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.Throwable") : class$java$lang$Throwable) && n < 4) {
                    n = 4;
                }
                if (classArray.length != 3 || !classArray[0].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) || !classArray[1].equals(class$java$lang$String == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String") : class$java$lang$String) || !classArray[2].equals(class$java$sql$SQLException == null ? SQLErrorCodeSQLExceptionTranslator.class$("java.sql.SQLException") : class$java$sql$SQLException) || n >= 5) continue;
                n = 5;
            }
            Constructor constructor = null;
            switch (n) {
                case 5: {
                    classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String, class$java$sql$SQLException == null ? (class$java$sql$SQLException = SQLErrorCodeSQLExceptionTranslator.class$("java.sql.SQLException")) : class$java$sql$SQLException};
                    Object[] objectArray = new Object[]{string, string2, sQLException};
                    constructor = clazz.getConstructor(classArray);
                    return (DataAccessException)constructor.newInstance(objectArray);
                }
                case 4: {
                    Class[] classArray2 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.Throwable")) : class$java$lang$Throwable};
                    Object[] objectArray = new Object[]{string, string2, sQLException};
                    constructor = clazz.getConstructor(classArray2);
                    return (DataAccessException)constructor.newInstance(objectArray);
                }
                case 3: {
                    Class[] classArray3 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String, class$java$sql$SQLException == null ? (class$java$sql$SQLException = SQLErrorCodeSQLExceptionTranslator.class$("java.sql.SQLException")) : class$java$sql$SQLException};
                    Object[] objectArray = new Object[]{string + ": " + sQLException.getMessage(), sQLException};
                    constructor = clazz.getConstructor(classArray3);
                    return (DataAccessException)constructor.newInstance(objectArray);
                }
                case 2: {
                    Class[] classArray4 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.Throwable")) : class$java$lang$Throwable};
                    Object[] objectArray = new Object[]{string + ": " + sQLException.getMessage(), sQLException};
                    constructor = clazz.getConstructor(classArray4);
                    return (DataAccessException)constructor.newInstance(objectArray);
                }
                case 1: {
                    Class[] classArray5 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SQLErrorCodeSQLExceptionTranslator.class$("java.lang.String")) : class$java$lang$String};
                    Object[] objectArray = new Object[]{string + ": " + sQLException.getMessage()};
                    constructor = clazz.getConstructor(classArray5);
                    return (DataAccessException)constructor.newInstance(objectArray);
                }
            }
            this.logger.warn((Object)("Unable to find appropriate constructor of custom exception class [" + clazz.getName() + "]"));
            return null;
        }
        catch (Throwable throwable) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Unable to instantiate custom exception class [" + clazz.getName() + "]"), throwable);
            }
            return null;
        }
    }

    private void logTranslation(String string, String string2, SQLException sQLException, boolean bl) {
        if (this.logger.isDebugEnabled()) {
            String string3 = bl ? "Custom translation of" : "Translating";
            this.logger.debug((Object)(string3 + " SQLException with SQL state '" + sQLException.getSQLState() + "', error code '" + sQLException.getErrorCode() + "', message [" + sQLException.getMessage() + "]; SQL was [" + string2 + "] for task [" + string + "]"));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

