/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.MetaDataAccessException;

public abstract class JdbcUtils {
    public static final int TYPE_UNKNOWN = Integer.MIN_VALUE;
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$support$JdbcUtils == null ? (class$org$springframework$jdbc$support$JdbcUtils = JdbcUtils.class$("org.springframework.jdbc.support.JdbcUtils")) : class$org$springframework$jdbc$support$JdbcUtils));
    static /* synthetic */ Class class$org$springframework$jdbc$support$JdbcUtils;

    public static void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                logger.debug((Object)"Could not close JDBC Connection", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Unexpected exception on closing JDBC Connection", throwable);
            }
        }
    }

    public static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                logger.debug((Object)"Could not close JDBC Statement", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Unexpected exception on closing JDBC Statement", throwable);
            }
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                logger.debug((Object)"Could not close JDBC ResultSet", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Unexpected exception on closing JDBC ResultSet", throwable);
            }
        }
    }

    public static Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
        Object object = resultSet.getObject(n);
        if (object instanceof Blob) {
            object = resultSet.getBytes(n);
        } else if (object instanceof Clob) {
            object = resultSet.getString(n);
        } else if (object != null && object.getClass().getName().startsWith("oracle.sql.TIMESTAMP")) {
            object = resultSet.getTimestamp(n);
        } else if (object != null && object.getClass().getName().startsWith("oracle.sql.DATE")) {
            String string = resultSet.getMetaData().getColumnClassName(n);
            object = "java.sql.Timestamp".equals(string) || "oracle.sql.TIMESTAMP".equals(string) ? resultSet.getTimestamp(n) : resultSet.getDate(n);
        } else if (object != null && object instanceof Date && "java.sql.Timestamp".equals(resultSet.getMetaData().getColumnClassName(n))) {
            object = resultSet.getTimestamp(n);
        }
        return object;
    }

    public static Object extractDatabaseMetaData(DataSource dataSource, DatabaseMetaDataCallback databaseMetaDataCallback) throws MetaDataAccessException {
        Connection connection = null;
        try {
            connection = DataSourceUtils.getConnection(dataSource);
            if (connection == null) {
                throw new MetaDataAccessException("Connection returned by DataSource [" + dataSource + "] was null");
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData == null) {
                throw new MetaDataAccessException("DatabaseMetaData returned by Connection [" + connection + "] was null");
            }
            Object object = databaseMetaDataCallback.processMetaData(databaseMetaData);
            return object;
        }
        catch (CannotGetJdbcConnectionException cannotGetJdbcConnectionException) {
            throw new MetaDataAccessException("Could not get Connection for extracting meta data", (Throwable)((Object)cannotGetJdbcConnectionException));
        }
        catch (SQLException sQLException) {
            throw new MetaDataAccessException("Error while extracting DatabaseMetaData", sQLException);
        }
        catch (AbstractMethodError abstractMethodError) {
            throw new MetaDataAccessException("JDBC DatabaseMetaData method not implemented by JDBC driver - upgrade your driver", abstractMethodError);
        }
        finally {
            DataSourceUtils.releaseConnection(connection, dataSource);
        }
    }

    public static Object extractDatabaseMetaData(DataSource dataSource, final String string) throws MetaDataAccessException {
        return JdbcUtils.extractDatabaseMetaData(dataSource, new DatabaseMetaDataCallback(){

            public Object processMetaData(DatabaseMetaData databaseMetaData) throws SQLException, MetaDataAccessException {
                try {
                    Method method = databaseMetaData.getClass().getMethod(string, null);
                    return method.invoke((Object)databaseMetaData, (Object[])null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new MetaDataAccessException("No method named '" + string + "' found on DatabaseMetaData instance [" + databaseMetaData + "]", noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new MetaDataAccessException("Could not access DatabaseMetaData method '" + string + "'", illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof SQLException) {
                        throw (SQLException)invocationTargetException.getTargetException();
                    }
                    throw new MetaDataAccessException("Invocation of DatabaseMetaData method '" + string + "' failed", invocationTargetException);
                }
            }
        });
    }

    public static boolean supportsBatchUpdates(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData != null) {
                if (databaseMetaData.supportsBatchUpdates()) {
                    logger.debug((Object)"JDBC driver supports batch updates");
                    return true;
                }
                logger.debug((Object)"JDBC driver does not support batch updates");
            }
        }
        catch (SQLException sQLException) {
            logger.debug((Object)"JDBC driver 'supportsBatchUpdates' method threw exception", (Throwable)sQLException);
        }
        catch (AbstractMethodError abstractMethodError) {
            logger.debug((Object)"JDBC driver does not support JDBC 2.0 'supportsBatchUpdates' method", (Throwable)abstractMethodError);
        }
        return false;
    }

    public static boolean isNumeric(int n) {
        return -7 == n || -5 == n || 3 == n || 8 == n || 6 == n || 4 == n || 2 == n || 7 == n || 5 == n || -6 == n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

