/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

public abstract class JdbcAccessor
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DataSource dataSource;
    private SQLExceptionTranslator exceptionTranslator;
    private boolean lazyInit = true;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDatabaseProductName(String string) {
        this.exceptionTranslator = new SQLErrorCodeSQLExceptionTranslator(string);
    }

    public void setExceptionTranslator(SQLExceptionTranslator sQLExceptionTranslator) {
        this.exceptionTranslator = sQLExceptionTranslator;
    }

    public synchronized SQLExceptionTranslator getExceptionTranslator() {
        if (this.exceptionTranslator == null) {
            DataSource dataSource = this.getDataSource();
            this.exceptionTranslator = dataSource != null ? new SQLErrorCodeSQLExceptionTranslator(dataSource) : new SQLStateSQLExceptionTranslator();
        }
        return this.exceptionTranslator;
    }

    public void setLazyInit(boolean bl) {
        this.lazyInit = bl;
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void afterPropertiesSet() {
        if (this.getDataSource() == null) {
            throw new IllegalArgumentException("Property 'dataSource' is required");
        }
        if (!this.isLazyInit()) {
            this.getExceptionTranslator();
        }
    }
}

