/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.KeyHolder;

public class GeneratedKeyHolder
implements KeyHolder {
    private final List keyList;
    static /* synthetic */ Class class$java$lang$Number;

    public GeneratedKeyHolder() {
        this.keyList = new LinkedList();
    }

    public GeneratedKeyHolder(List list) {
        this.keyList = list;
    }

    public Number getKey() throws InvalidDataAccessApiUsageException, DataRetrievalFailureException {
        if (this.keyList.size() == 0) {
            return null;
        }
        if (this.keyList.size() > 1 || ((Map)this.keyList.get(0)).size() > 1) {
            throw new InvalidDataAccessApiUsageException("The getKey method should only be used when a single key is returned.  The current key entry contains multiple keys: " + this.keyList);
        }
        Iterator iterator = ((Map)this.keyList.get(0)).values().iterator();
        if (iterator.hasNext()) {
            Object v = iterator.next();
            if (!(v instanceof Number)) {
                throw new DataRetrievalFailureException("The generated key is not of a supported numeric type. Unable to cast [" + (v != null ? v.getClass().getName() : null) + "] to [" + (class$java$lang$Number == null ? (class$java$lang$Number = GeneratedKeyHolder.class$("java.lang.Number")) : class$java$lang$Number).getName() + "]");
            }
            return (Number)v;
        }
        throw new DataRetrievalFailureException("Unable to retrieve the generated key. Check that the table has an identity column enabled.");
    }

    public Map getKeys() throws InvalidDataAccessApiUsageException {
        if (this.keyList.size() == 0) {
            return null;
        }
        if (this.keyList.size() > 1) {
            throw new InvalidDataAccessApiUsageException("The getKeys method should only be used when keys for a single row are returned.  The current key list contains keys for multiple rows: " + this.keyList);
        }
        return (Map)this.keyList.get(0);
    }

    public List getKeyList() {
        return this.keyList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

