/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.support.JdbcUtils;

public class DatabaseStartupValidator
implements InitializingBean {
    public static final int DEFAULT_INTERVAL = 1;
    public static final int DEFAULT_TIMEOUT = 60;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DataSource dataSource;
    private String validationQuery;
    private int interval = 1;
    private int timeout = 60;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = string;
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("dataSource is required");
        }
        if (this.validationQuery == null) {
            throw new IllegalArgumentException("validationQuery is required");
        }
        boolean bl = false;
        long l = System.currentTimeMillis();
        long l2 = l + (long)(this.timeout * 1000);
        SQLException sQLException = null;
        while (!bl && System.currentTimeMillis() < l2) {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = this.dataSource.getConnection();
                statement = connection.createStatement();
                statement.execute(this.validationQuery);
                bl = true;
            }
            catch (SQLException sQLException2) {
                block12: {
                    try {
                        sQLException = sQLException2;
                        this.logger.debug((Object)("Validation query [" + this.validationQuery + "] threw exception"), (Throwable)sQLException2);
                        float f = (float)(l2 - System.currentTimeMillis()) / 1000.0f;
                        if (!(f > (float)this.interval)) break block12;
                        this.logger.warn((Object)("Database has not started up yet - retrying in " + this.interval + " seconds (timeout in " + f + " seconds)"));
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeStatement(statement);
                        JdbcUtils.closeConnection(connection);
                        throw throwable;
                    }
                }
                JdbcUtils.closeStatement(statement);
                JdbcUtils.closeConnection(connection);
            }
            JdbcUtils.closeStatement(statement);
            JdbcUtils.closeConnection(connection);
            try {
                Thread.sleep(this.interval * 1000);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (bl) {
            float f = (System.currentTimeMillis() - l) / 1000L;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Database startup detected after " + f + " seconds"));
            }
        } else {
            throw new CannotGetJdbcConnectionException("Database has not started up within " + this.timeout + " seconds", sQLException);
        }
    }
}

