/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.object.SqlQuery;

public abstract class UpdatableSqlQuery
extends SqlQuery {
    public UpdatableSqlQuery() {
        this.setUpdatableResults(true);
    }

    public UpdatableSqlQuery(DataSource dataSource, String string) {
        super(dataSource, string);
        this.setUpdatableResults(true);
    }

    protected RowMapper newRowMapper(Object[] objectArray, Map map) {
        return new RowMapperImpl(map);
    }

    protected abstract Object updateRow(ResultSet var1, int var2, Map var3) throws SQLException;

    protected class RowMapperImpl
    implements RowMapper {
        private final Map context;

        public RowMapperImpl(Map map) {
            this.context = map;
        }

        public Object mapRow(ResultSet resultSet, int n) throws SQLException {
            Object object = UpdatableSqlQuery.this.updateRow(resultSet, n, this.context);
            resultSet.updateRow();
            return object;
        }
    }
}

