/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.SqlCall;

public abstract class StoredProcedure
extends SqlCall {
    protected StoredProcedure() {
    }

    protected StoredProcedure(DataSource dataSource, String string) {
        this.setDataSource(dataSource);
        this.setSql(string);
    }

    protected StoredProcedure(JdbcTemplate jdbcTemplate, String string) {
        this.setJdbcTemplate(jdbcTemplate);
        this.setSql(string);
    }

    protected boolean allowsUnusedParameters() {
        return true;
    }

    public void declareParameter(SqlParameter sqlParameter) throws InvalidDataAccessApiUsageException {
        if (sqlParameter.getName() == null) {
            throw new InvalidDataAccessApiUsageException("Parameters to stored procedures must have names as well as types");
        }
        super.declareParameter(sqlParameter);
    }

    public Map execute(Map map) throws DataAccessException {
        this.validateParameters(map.values().toArray());
        return this.getJdbcTemplate().call(this.newCallableStatementCreator(map), this.getDeclaredParameters());
    }

    public Map execute(ParameterMapper parameterMapper) throws DataAccessException {
        this.checkCompiled();
        return this.getJdbcTemplate().call(this.newCallableStatementCreator(parameterMapper), this.getDeclaredParameters());
    }
}

