/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.JdbcUpdateAffectedIncorrectNumberOfRowsException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.object.SqlOperation;
import org.springframework.jdbc.support.KeyHolder;

public class SqlUpdate
extends SqlOperation {
    private int maxRowsAffected = 0;
    private int requiredRowsAffected = 0;

    public SqlUpdate() {
    }

    public SqlUpdate(DataSource dataSource, String string) {
        this.setDataSource(dataSource);
        this.setSql(string);
    }

    public SqlUpdate(DataSource dataSource, String string, int[] nArray) {
        this.setDataSource(dataSource);
        this.setSql(string);
        this.setTypes(nArray);
    }

    public SqlUpdate(DataSource dataSource, String string, int[] nArray, int n) {
        this.setDataSource(dataSource);
        this.setSql(string);
        this.setTypes(nArray);
        this.maxRowsAffected = n;
    }

    public void setMaxRowsAffected(int n) {
        this.maxRowsAffected = n;
    }

    public void setRequiredRowsAffected(int n) {
        this.requiredRowsAffected = n;
    }

    protected void checkRowsAffected(int n) throws JdbcUpdateAffectedIncorrectNumberOfRowsException {
        if (this.maxRowsAffected > 0 && n > this.maxRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(this.getSql(), this.maxRowsAffected, n);
        }
        if (this.requiredRowsAffected > 0 && n != this.requiredRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(this.getSql(), this.requiredRowsAffected, n);
        }
    }

    public int update(Object[] objectArray) throws DataAccessException {
        this.validateParameters(objectArray);
        int n = this.getJdbcTemplate().update(this.newPreparedStatementCreator(objectArray));
        this.checkRowsAffected(n);
        return n;
    }

    public int update(Object[] objectArray, KeyHolder keyHolder) throws DataAccessException {
        this.validateParameters(objectArray);
        int n = this.getJdbcTemplate().update(this.newPreparedStatementCreator(objectArray), keyHolder);
        this.checkRowsAffected(n);
        return n;
    }

    public int update() throws DataAccessException {
        return this.update((Object[])null);
    }

    public int update(int n) throws DataAccessException {
        return this.update(new Object[]{new Integer(n)});
    }

    public int update(int n, int n2) throws DataAccessException {
        return this.update(new Object[]{new Integer(n), new Integer(n2)});
    }

    public int update(long l) throws DataAccessException {
        return this.update(new Object[]{new Long(l)});
    }

    public int update(long l, long l2) throws DataAccessException {
        return this.update(new Object[]{new Long(l), new Long(l2)});
    }

    public int update(String string) throws DataAccessException {
        return this.update(new Object[]{string});
    }

    public int update(String string, String string2) throws DataAccessException {
        return this.update(new Object[]{string, string2});
    }

    public int updateByNamedParam(Map map) throws DataAccessException {
        this.validateNamedParameters(map);
        ParsedSql parsedSql = this.getParsedSql();
        MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource(map);
        String string = NamedParameterUtils.substituteNamedParameters(parsedSql, (SqlParameterSource)mapSqlParameterSource);
        Object[] objectArray = NamedParameterUtils.buildValueArray(parsedSql, mapSqlParameterSource, this.getDeclaredParameters());
        int n = this.getJdbcTemplate().update(this.newPreparedStatementCreator(string, objectArray));
        this.checkRowsAffected(n);
        return n;
    }

    public int updateByNamedParam(Map map, KeyHolder keyHolder) throws DataAccessException {
        this.validateNamedParameters(map);
        ParsedSql parsedSql = this.getParsedSql();
        MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource(map);
        String string = NamedParameterUtils.substituteNamedParameters(parsedSql, (SqlParameterSource)mapSqlParameterSource);
        Object[] objectArray = NamedParameterUtils.buildValueArray(parsedSql, mapSqlParameterSource, this.getDeclaredParameters());
        int n = this.getJdbcTemplate().update(this.newPreparedStatementCreator(string, objectArray), keyHolder);
        this.checkRowsAffected(n);
        return n;
    }
}

