/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.object.SqlOperation;

public abstract class SqlQuery
extends SqlOperation {
    private int rowsExpected = 0;

    public SqlQuery() {
    }

    public SqlQuery(DataSource dataSource, String string) {
        this.setDataSource(dataSource);
        this.setSql(string);
    }

    public void setRowsExpected(int n) {
        this.rowsExpected = n;
    }

    public int getRowsExpected() {
        return this.rowsExpected;
    }

    public List execute(Object[] objectArray, Map map) throws DataAccessException {
        this.validateParameters(objectArray);
        RowMapper rowMapper = this.newRowMapper(objectArray, map);
        return this.getJdbcTemplate().query(this.newPreparedStatementCreator(objectArray), rowMapper);
    }

    public List execute(Object[] objectArray) throws DataAccessException {
        return this.execute(objectArray, null);
    }

    public List execute(Map map) throws DataAccessException {
        return this.execute((Object[])null, map);
    }

    public List execute() throws DataAccessException {
        return this.execute((Object[])null);
    }

    public List execute(int n, Map map) throws DataAccessException {
        return this.execute(new Object[]{new Integer(n)}, map);
    }

    public List execute(int n) throws DataAccessException {
        return this.execute(n, (Map)null);
    }

    public List execute(int n, int n2, Map map) throws DataAccessException {
        return this.execute(new Object[]{new Integer(n), new Integer(n2)}, map);
    }

    public List execute(int n, int n2) throws DataAccessException {
        return this.execute(n, n2, null);
    }

    public List execute(long l, Map map) throws DataAccessException {
        return this.execute(new Object[]{new Long(l)}, map);
    }

    public List execute(long l) throws DataAccessException {
        return this.execute(l, null);
    }

    public List execute(String string, Map map) throws DataAccessException {
        return this.execute(new Object[]{string}, map);
    }

    public List execute(String string) throws DataAccessException {
        return this.execute(string, null);
    }

    public List executeByNamedParam(Map map, Map map2) throws DataAccessException {
        this.validateNamedParameters(map);
        ParsedSql parsedSql = this.getParsedSql();
        MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource(map);
        String string = NamedParameterUtils.substituteNamedParameters(parsedSql, (SqlParameterSource)mapSqlParameterSource);
        Object[] objectArray = NamedParameterUtils.buildValueArray(parsedSql, mapSqlParameterSource, this.getDeclaredParameters());
        RowMapper rowMapper = this.newRowMapper(objectArray, map2);
        return this.getJdbcTemplate().query(this.newPreparedStatementCreator(string, objectArray), rowMapper);
    }

    public List executeByNamedParam(Map map) throws DataAccessException {
        return this.executeByNamedParam(map, null);
    }

    public Object findObject(Object[] objectArray, Map map) throws DataAccessException {
        List list = this.execute(objectArray, map);
        return DataAccessUtils.singleResult((Collection)list);
    }

    public Object findObject(Object[] objectArray) throws DataAccessException {
        return this.findObject(objectArray, null);
    }

    public Object findObject(int n, Map map) throws DataAccessException {
        return this.findObject(new Object[]{new Integer(n)}, map);
    }

    public Object findObject(int n) throws DataAccessException {
        return this.findObject(n, (Map)null);
    }

    public Object findObject(int n, int n2, Map map) throws DataAccessException {
        return this.findObject(new Object[]{new Integer(n), new Integer(n2)}, map);
    }

    public Object findObject(int n, int n2) throws DataAccessException {
        return this.findObject(n, n2, null);
    }

    public Object findObject(long l, Map map) throws DataAccessException {
        return this.findObject(new Object[]{new Long(l)}, map);
    }

    public Object findObject(long l) throws DataAccessException {
        return this.findObject(l, null);
    }

    public Object findObject(String string, Map map) throws DataAccessException {
        return this.findObject(new Object[]{string}, map);
    }

    public Object findObject(String string) throws DataAccessException {
        return this.findObject(string, null);
    }

    public Object findObjectByNamedParam(Map map, Map map2) throws DataAccessException {
        List list = this.executeByNamedParam(map, map2);
        return DataAccessUtils.singleResult((Collection)list);
    }

    public Object findObjectByNamedParam(Map map) throws DataAccessException {
        return this.findObjectByNamedParam(map, null);
    }

    protected abstract RowMapper newRowMapper(Object[] var1, Map var2);
}

