/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.object.MappingSqlQuery;

public class SqlFunction
extends MappingSqlQuery {
    private final SingleColumnRowMapper rowMapper = new SingleColumnRowMapper();

    public SqlFunction() {
        this.setRowsExpected(1);
    }

    public SqlFunction(DataSource dataSource, String string) {
        this.setRowsExpected(1);
        this.setDataSource(dataSource);
        this.setSql(string);
    }

    public SqlFunction(DataSource dataSource, String string, int[] nArray) {
        this.setRowsExpected(1);
        this.setDataSource(dataSource);
        this.setSql(string);
        this.setTypes(nArray);
    }

    public SqlFunction(DataSource dataSource, String string, int[] nArray, Class clazz) {
        this.setRowsExpected(1);
        this.setDataSource(dataSource);
        this.setSql(string);
        this.setTypes(nArray);
        this.setResultType(clazz);
    }

    public void setResultType(Class clazz) {
        this.rowMapper.setRequiredType(clazz);
    }

    protected Object mapRow(ResultSet resultSet, int n) throws SQLException {
        return this.rowMapper.mapRow(resultSet, n);
    }

    public int run() {
        return this.run(null);
    }

    public int run(int n) {
        return this.run(new Object[]{new Integer(n)});
    }

    public int run(Object[] objectArray) {
        Object object = super.findObject(objectArray);
        if (!(object instanceof Number)) {
            throw new TypeMismatchDataAccessException("Couldn't convert result object [" + object + "] to int");
        }
        return ((Number)object).intValue();
    }

    public Object runGeneric() {
        return this.findObject((Object[])null);
    }

    public Object runGeneric(int n) {
        return this.findObject(n);
    }

    public Object runGeneric(Object[] objectArray) {
        return this.findObject(objectArray);
    }
}

