/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.CallableStatementCreatorFactory;
import org.springframework.jdbc.core.ParameterMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.object.RdbmsOperation;

public abstract class SqlCall
extends RdbmsOperation {
    private CallableStatementCreatorFactory callableStatementFactory;
    private boolean function = false;
    private boolean sqlReadyForUse = false;
    private String callString;

    public SqlCall() {
    }

    public SqlCall(DataSource dataSource, String string) {
        this.setDataSource(dataSource);
        this.setSql(string);
    }

    public void setFunction(boolean bl) {
        this.function = bl;
    }

    public boolean isFunction() {
        return this.function;
    }

    public void setSqlReadyForUse(boolean bl) {
        this.sqlReadyForUse = bl;
    }

    public boolean isSqlReadyForUse() {
        return this.sqlReadyForUse;
    }

    protected final void compileInternal() {
        if (this.isSqlReadyForUse()) {
            this.callString = this.getSql();
        } else {
            List list = this.getDeclaredParameters();
            int n = 0;
            if (this.isFunction()) {
                this.callString = "{? = call " + this.getSql() + "(";
                n = -1;
            } else {
                this.callString = "{call " + this.getSql() + "(";
            }
            for (int i = 0; i < list.size(); ++i) {
                SqlParameter sqlParameter = (SqlParameter)list.get(i);
                if (sqlParameter instanceof SqlReturnResultSet) continue;
                if (n > 0) {
                    this.callString = this.callString + ", ";
                }
                if (n >= 0) {
                    this.callString = this.callString + "?";
                }
                ++n;
            }
            this.callString = this.callString + ")}";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Compiled stored procedure. Call string is [" + this.getCallString() + "]"));
        }
        this.callableStatementFactory = new CallableStatementCreatorFactory(this.getCallString(), this.getDeclaredParameters());
        this.callableStatementFactory.setResultSetType(this.getResultSetType());
        this.callableStatementFactory.setUpdatableResults(this.isUpdatableResults());
        this.callableStatementFactory.setNativeJdbcExtractor(this.getJdbcTemplate().getNativeJdbcExtractor());
        this.onCompileInternal();
    }

    protected void onCompileInternal() {
    }

    public String getCallString() {
        return this.callString;
    }

    protected CallableStatementCreator newCallableStatementCreator(Map map) {
        return this.callableStatementFactory.newCallableStatementCreator(map);
    }

    protected CallableStatementCreator newCallableStatementCreator(ParameterMapper parameterMapper) {
        return this.callableStatementFactory.newCallableStatementCreator(parameterMapper);
    }
}

