/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetSupportingSqlParameter;
import org.springframework.jdbc.core.SqlParameter;

public abstract class RdbmsOperation
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JdbcTemplate jdbcTemplate = new JdbcTemplate();
    private int resultSetType = 1003;
    private boolean updatableResults = false;
    private boolean returnGeneratedKeys = false;
    private String[] generatedKeysColumnNames = null;
    private String sql;
    private List declaredParameters = new LinkedList();
    private boolean compiled;

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        if (jdbcTemplate == null) {
            throw new IllegalArgumentException("jdbcTemplate must not be null");
        }
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate.setDataSource(dataSource);
    }

    public void setFetchSize(int n) {
        this.jdbcTemplate.setFetchSize(n);
    }

    public void setMaxRows(int n) {
        this.jdbcTemplate.setMaxRows(n);
    }

    public void setQueryTimeout(int n) {
        this.jdbcTemplate.setQueryTimeout(n);
    }

    public void setResultSetType(int n) {
        this.resultSetType = n;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public void setUpdatableResults(boolean bl) {
        if (this.isCompiled()) {
            throw new InvalidDataAccessApiUsageException("The updateableResults flag must be set before the operation is compiled");
        }
        this.updatableResults = bl;
    }

    public boolean isUpdatableResults() {
        return this.updatableResults;
    }

    public void setReturnGeneratedKeys(boolean bl) {
        if (this.isCompiled()) {
            throw new InvalidDataAccessApiUsageException("The returnGeneratedKeys flag must be set before the operation is compiled");
        }
        this.returnGeneratedKeys = bl;
    }

    public boolean isReturnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }

    public void setGeneratedKeysColumnNames(String[] stringArray) {
        if (this.isCompiled()) {
            throw new InvalidDataAccessApiUsageException("The column names for the generated keys must be set before the operation is compiled");
        }
        this.generatedKeysColumnNames = stringArray;
    }

    public String[] getGeneratedKeysColumnNames() {
        return this.generatedKeysColumnNames;
    }

    public void setSql(String string) {
        this.sql = string;
    }

    public String getSql() {
        return this.sql;
    }

    public void setTypes(int[] nArray) throws InvalidDataAccessApiUsageException {
        if (this.isCompiled()) {
            throw new InvalidDataAccessApiUsageException("Cannot add parameters once query is compiled");
        }
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.declareParameter(new SqlParameter(nArray[i]));
            }
        }
    }

    public void declareParameter(SqlParameter sqlParameter) throws InvalidDataAccessApiUsageException {
        if (this.isCompiled()) {
            throw new InvalidDataAccessApiUsageException("Cannot add parameters once the query is compiled");
        }
        this.declaredParameters.add(sqlParameter);
    }

    protected List getDeclaredParameters() {
        return this.declaredParameters;
    }

    public void afterPropertiesSet() {
        this.compile();
    }

    public final void compile() throws InvalidDataAccessApiUsageException {
        if (!this.isCompiled()) {
            if (this.getSql() == null) {
                throw new InvalidDataAccessApiUsageException("Property 'sql' is required");
            }
            try {
                this.jdbcTemplate.afterPropertiesSet();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidDataAccessApiUsageException(illegalArgumentException.getMessage());
            }
            this.compileInternal();
            this.compiled = true;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("RdbmsOperation with SQL [" + this.getSql() + "] compiled"));
            }
        }
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    protected void checkCompiled() {
        if (!this.isCompiled()) {
            this.logger.debug((Object)"SQL operation not compiled before execution - invoking compile");
            this.compile();
        }
    }

    protected void validateParameters(Object[] objectArray) throws InvalidDataAccessApiUsageException {
        this.checkCompiled();
        int n = 0;
        if (this.declaredParameters != null) {
            Iterator iterator = this.declaredParameters.iterator();
            while (iterator.hasNext()) {
                SqlParameter sqlParameter = (SqlParameter)iterator.next();
                if (sqlParameter instanceof ResultSetSupportingSqlParameter) continue;
                if (!(this.supportsLobParameters() || sqlParameter.getSqlType() != 2004 && sqlParameter.getSqlType() != 2005)) {
                    throw new InvalidDataAccessApiUsageException("BLOB or CLOB parameters are not allowed for this kind of operation");
                }
                ++n;
            }
        }
        this.validateParameterCount(objectArray != null ? objectArray.length : 0, n);
    }

    protected void validateNamedParameters(Map map) throws InvalidDataAccessApiUsageException {
        this.checkCompiled();
        Map map2 = map != null ? map : Collections.EMPTY_MAP;
        int n = 0;
        if (this.declaredParameters != null) {
            Iterator iterator = this.declaredParameters.iterator();
            while (iterator.hasNext()) {
                SqlParameter sqlParameter = (SqlParameter)iterator.next();
                if (sqlParameter instanceof ResultSetSupportingSqlParameter) continue;
                if (!(this.supportsLobParameters() || sqlParameter.getSqlType() != 2004 && sqlParameter.getSqlType() != 2005)) {
                    throw new InvalidDataAccessApiUsageException("BLOB or CLOB parameters are not allowed for this kind of operation");
                }
                if (sqlParameter.getName() != null && !map2.containsKey(sqlParameter.getName())) {
                    throw new InvalidDataAccessApiUsageException("The parameter named '" + sqlParameter.getName() + "' was not among the parameters supplied: " + map2.keySet());
                }
                ++n;
            }
        }
        this.validateParameterCount(map2.size(), n);
    }

    private void validateParameterCount(int n, int n2) {
        if (n > 0) {
            if (n2 == 0) {
                throw new InvalidDataAccessApiUsageException("Didn't expect any parameters: none were declared");
            }
            if (n < n2) {
                throw new InvalidDataAccessApiUsageException(n + " parameters were supplied, but " + n2 + " in parameters were declared in class [" + this.getClass().getName() + "]");
            }
            if (!this.allowsUnusedParameters() && n > n2) {
                throw new InvalidDataAccessApiUsageException(n + " parameters were supplied, but " + n2 + " parameters were declared " + "in class [" + this.getClass().getName() + "]");
            }
        } else if (n2 > 0) {
            throw new InvalidDataAccessApiUsageException(n2 + " parameters must be supplied");
        }
    }

    protected abstract void compileInternal() throws InvalidDataAccessApiUsageException;

    protected boolean supportsLobParameters() {
        return true;
    }

    protected boolean allowsUnusedParameters() {
        return false;
    }
}

