/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.object.SqlUpdate;

public class BatchSqlUpdate
extends SqlUpdate {
    public static int DEFAULT_BATCH_SIZE = 5000;
    private int batchSize = DEFAULT_BATCH_SIZE;
    private boolean trackRowsAffected = true;
    private final LinkedList parameterQueue = new LinkedList();
    private final List rowsAffected = new ArrayList();

    public BatchSqlUpdate() {
    }

    public BatchSqlUpdate(DataSource dataSource, String string) {
        super(dataSource, string);
    }

    public BatchSqlUpdate(DataSource dataSource, String string, int[] nArray) {
        super(dataSource, string, nArray);
    }

    public BatchSqlUpdate(DataSource dataSource, String string, int[] nArray, int n) {
        super(dataSource, string, nArray);
        this.setBatchSize(n);
    }

    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    public void setTrackRowsAffected(boolean bl) {
        this.trackRowsAffected = bl;
    }

    protected boolean supportsLobParameters() {
        return false;
    }

    public int update(Object[] objectArray) throws DataAccessException {
        this.validateParameters(objectArray);
        this.parameterQueue.add(objectArray.clone());
        if (this.parameterQueue.size() == this.batchSize) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Triggering auto-flush because queue reached batch size of " + this.batchSize));
            }
            this.flush();
        }
        return -1;
    }

    public int[] flush() {
        int n;
        if (this.parameterQueue.isEmpty()) {
            return new int[0];
        }
        int[] nArray = this.getJdbcTemplate().batchUpdate(this.getSql(), new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return BatchSqlUpdate.this.parameterQueue.size();
            }

            public void setValues(PreparedStatement preparedStatement, int n) throws SQLException {
                Object[] objectArray = (Object[])BatchSqlUpdate.this.parameterQueue.removeFirst();
                BatchSqlUpdate.this.newPreparedStatementSetter(objectArray).setValues(preparedStatement);
            }
        });
        if (this.trackRowsAffected) {
            for (n = 0; n < nArray.length; ++n) {
                this.rowsAffected.add(new Integer(nArray[n]));
            }
        }
        for (n = 0; n < nArray.length; ++n) {
            this.checkRowsAffected(nArray[n]);
        }
        return nArray;
    }

    public int getQueueCount() {
        return this.parameterQueue.size();
    }

    public int getExecutionCount() {
        return this.rowsAffected.size();
    }

    public int[] getRowsAffected() {
        int[] nArray = new int[this.rowsAffected.size()];
        int n = 0;
        Iterator iterator = this.rowsAffected.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    public void reset() {
        this.parameterQueue.clear();
        this.rowsAffected.clear();
    }
}

