/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.lookup;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.DataSourceLookupFailureException;
import org.springframework.util.Assert;

public class MapDataSourceLookup
implements DataSourceLookup {
    private final Map dataSources = new HashMap(4);

    public MapDataSourceLookup() {
    }

    public MapDataSourceLookup(Map map) {
        this.setDataSources(map);
    }

    public MapDataSourceLookup(String string, DataSource dataSource) {
        this.addDataSource(string, dataSource);
    }

    public void setDataSources(Map map) {
        if (map != null) {
            this.dataSources.putAll(map);
        }
    }

    public Map getDataSources() {
        return Collections.unmodifiableMap(this.dataSources);
    }

    public void addDataSource(String string, DataSource dataSource) {
        Assert.notNull((Object)string, (String)"DataSource name must not be null");
        Assert.notNull((Object)dataSource, (String)"DataSource must not be null");
        this.dataSources.put(string, dataSource);
    }

    public DataSource getDataSource(String string) throws DataSourceLookupFailureException {
        Assert.notNull((Object)string, (String)"DataSource name must not be null");
        Object v = this.dataSources.get(string);
        if (v == null) {
            throw new DataSourceLookupFailureException("No DataSource with name '" + string + "' registered");
        }
        if (!(v instanceof DataSource)) {
            throw new DataSourceLookupFailureException("The object [" + v + "] with name '" + string + "' in the DataSource map is not a [javax.sql.DataSource]");
        }
        return (DataSource)v;
    }
}

